/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import net.sf.jstuff.core.collection.iterator.Iterators;
import net.sf.jstuff.core.validation.Args;
import org.eclipse.jdt.annotation.Nullable;

public class MapBasedNamespaceContext
implements NamespaceContext {
    protected final Map<String, List<String>> namespaceURIsByPrefix = new HashMap<String, List<String>>(2);
    protected final Map<String, List<String>> prefixesByNamespaceURI = new HashMap<String, List<String>>(2);
    private String defaultNamespaceURI = "";

    public void bindDefaultNameSpace(String namespaceURI) {
        this.defaultNamespaceURI = namespaceURI;
    }

    public void bindNamespace(String namespaceURI, String prefix) {
        Args.notNull((String)"namespaceURI", (Object)namespaceURI);
        Args.notNull((String)"prefix", (Object)prefix);
        if (prefix.equals("")) {
            this.defaultNamespaceURI = namespaceURI;
        }
        this.namespaceURIsByPrefix.computeIfAbsent(prefix, unused -> new ArrayList(2)).add(namespaceURI);
        this.prefixesByNamespaceURI.computeIfAbsent(namespaceURI, unused -> new ArrayList(2)).add(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Args.notNull((String)"prefix", (Object)prefix);
        if (prefix.equals("")) {
            return this.defaultNamespaceURI;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        List<String> nsURI = this.namespaceURIsByPrefix.get(prefix);
        return nsURI == null ? "" : nsURI.get(0);
    }

    @Override
    public @Nullable String getPrefix(String namespaceURI) {
        Args.notNull((String)"namespaceURI", (Object)namespaceURI);
        if (namespaceURI.equals(this.defaultNamespaceURI)) {
            return "";
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        List<String> prefix = this.prefixesByNamespaceURI.get(namespaceURI);
        return prefix == null ? null : prefix.get(0);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        Args.notNull((String)"namespaceURI", (Object)namespaceURI);
        List<String> prefix = this.prefixesByNamespaceURI.get(namespaceURI);
        return prefix == null ? Iterators.empty() : prefix.iterator();
    }
}

