/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.stream;

import javax.xml.stream.XMLStreamReader;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.xml.stream.DelegatingXMLStreamReader;
import org.eclipse.jdt.annotation.Nullable;

public class ExtendedXMLStreamReader
extends DelegatingXMLStreamReader {
    public ExtendedXMLStreamReader(XMLStreamReader wrapped) {
        super(wrapped);
    }

    public @Nullable String getAttributeValue(String attrLocalName) {
        int i = 0;
        while (i < this.getAttributeCount()) {
            String localName = this.getAttributeLocalName(i);
            if (localName.equals(attrLocalName)) {
                return this.getAttributeValue(i);
            }
            ++i;
        }
        return null;
    }

    public boolean getAttributeValueAsBoolean(String attrLocalName, boolean defaultValue) {
        String val = this.getAttributeValue(attrLocalName);
        if (val == null || Strings.isBlank((CharSequence)val)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }

    public byte getAttributeValueAsByte(String attrLocalName, byte defaultValue) {
        String val = this.getAttributeValue(attrLocalName);
        if (val == null || Strings.isBlank((CharSequence)val)) {
            return defaultValue;
        }
        return Byte.parseByte(val);
    }

    public int getAttributeValueAsInt(String attrLocalName, int defaultValue) {
        String val = this.getAttributeValue(attrLocalName);
        if (val == null || Strings.isBlank((CharSequence)val)) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    public long getAttributeValueAsLong(String attrLocalName, long defaultValue) {
        String val = this.getAttributeValue(attrLocalName);
        if (val == null || Strings.isBlank((CharSequence)val)) {
            return defaultValue;
        }
        return Long.parseLong(val);
    }

    public String getAttributeValueOrElse(String attrLocalName, String defaultValue) {
        int i = 0;
        while (i < this.getAttributeCount()) {
            String localName = this.getAttributeLocalName(i);
            if (localName.equals(attrLocalName)) {
                return this.getAttributeValue(i);
            }
            ++i;
        }
        return defaultValue;
    }
}

