/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.stream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.xml.stream.ExtendedXMLStreamWriter;

public class IndentingXMLStreamWriter
extends ExtendedXMLStreamWriter {
    private String indention = "  ";
    private int indentionLevel;
    private boolean indentEndTag = true;

    public IndentingXMLStreamWriter(XMLStreamWriter wrapped) {
        super(wrapped);
    }

    public void setIndention(String indention) {
        this.indention = indention;
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writeIndention();
        super.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.indentEndTag = false;
        super.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.indentEndTag = false;
        super.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writeIndention();
        super.writeComment(data);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeIndention();
        super.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndention();
        super.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndention();
        super.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.indentionLevel;
        if (this.indentEndTag) {
            this.writeIndention();
        } else {
            this.indentEndTag = true;
        }
        super.writeEndElement();
    }

    private void writeIndention() throws XMLStreamException {
        ((XMLStreamWriter)this.wrapped).writeCharacters(Strings.NEW_LINE);
        int i = 0;
        while (i < this.indentionLevel) {
            ((XMLStreamWriter)this.wrapped).writeCharacters(this.indention);
            ++i;
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndention();
        ++this.indentionLevel;
        super.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndention();
        ++this.indentionLevel;
        super.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndention();
        ++this.indentionLevel;
        super.writeStartElement(prefix, localName, namespaceURI);
    }
}

