/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.jstuff.core.io.IOUtils;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.xml.stream.AutoCloseableXMLEventReader;
import net.sf.jstuff.xml.stream.AutoCloseableXMLEventWriter;
import net.sf.jstuff.xml.stream.DelegatingXMLEventReader;
import net.sf.jstuff.xml.stream.DelegatingXMLEventWriter;
import net.sf.jstuff.xml.stream.ExtendedXMLStreamReader;
import net.sf.jstuff.xml.stream.ExtendedXMLStreamWriter;

public class StAXFactory {
    private final ThreadLocal<XMLInputFactory> xmlInputFactory = ThreadLocal.withInitial(this::createXMLInputFactory);
    private final ThreadLocal<XMLOutputFactory> xmlOutputFactory = ThreadLocal.withInitial(this::createXMLOutputFactory);

    public AutoCloseableXMLEventReader createXMLEventReader(File xmlFile) throws FileNotFoundException, XMLStreamException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Args.isFileReadable((String)"xmlFile", (File)xmlFile);
        final BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlFile));
        XMLEventReader reader = this.xmlInputFactory.get().createXMLEventReader(is);
        return new DelegatingXMLEventReader(reader){

            @Override
            public void close() throws XMLStreamException {
                super.close();
                IOUtils.closeQuietly((InputStream)is);
            }
        };
    }

    public AutoCloseableXMLEventReader createXMLEventReader(InputStream xmlInput, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlInput", (Object)xmlInput);
        final InputStream is = xmlInput instanceof BufferedInputStream ? xmlInput : new BufferedInputStream(xmlInput);
        XMLEventReader reader = this.xmlInputFactory.get().createXMLEventReader(is);
        if (autoClose) {
            return new DelegatingXMLEventReader(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((InputStream)is);
                }
            };
        }
        return new DelegatingXMLEventReader(reader);
    }

    public AutoCloseableXMLEventReader createXMLEventReader(final Reader xmlReader, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlReader", (Object)xmlReader);
        XMLEventReader reader = this.xmlInputFactory.get().createXMLEventReader(xmlReader);
        if (autoClose) {
            return new DelegatingXMLEventReader(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Reader)xmlReader);
                }
            };
        }
        return new DelegatingXMLEventReader(reader);
    }

    public AutoCloseableXMLEventReader createXMLEventReader(Source xmlSource) throws XMLStreamException {
        Args.notNull((String)"xmlSource", (Object)xmlSource);
        XMLEventReader reader = this.xmlInputFactory.get().createXMLEventReader(xmlSource);
        return new DelegatingXMLEventReader(reader);
    }

    public AutoCloseableXMLEventReader createXMLEventReader(final StreamSource xmlSource, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlSource", (Object)xmlSource);
        XMLEventReader reader = this.xmlInputFactory.get().createXMLEventReader(xmlSource);
        if (autoClose) {
            return new DelegatingXMLEventReader(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Reader)xmlSource.getReader());
                    IOUtils.closeQuietly((InputStream)xmlSource.getInputStream());
                }
            };
        }
        return new DelegatingXMLEventReader(reader);
    }

    public AutoCloseableXMLEventWriter createXMLEventWriter(File xmlFile) throws FileNotFoundException, XMLStreamException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Args.isFileWriteable((String)"xmlFile", (File)xmlFile);
        final BufferedOutputStream is = new BufferedOutputStream(new FileOutputStream(xmlFile));
        XMLEventWriter writer = this.xmlOutputFactory.get().createXMLEventWriter(is);
        return new DelegatingXMLEventWriter(writer){

            @Override
            public void close() throws XMLStreamException {
                super.close();
                IOUtils.closeQuietly((OutputStream)is);
            }
        };
    }

    public AutoCloseableXMLEventWriter createXMLEventWriter(OutputStream xmlOutput, Charset encoding, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlOutput", (Object)xmlOutput);
        Args.notNull((String)"encoding", (Object)encoding);
        final OutputStream os = xmlOutput instanceof BufferedOutputStream ? xmlOutput : new BufferedOutputStream(xmlOutput);
        XMLEventWriter reader = this.xmlOutputFactory.get().createXMLEventWriter(os, encoding.name());
        if (autoClose) {
            return new DelegatingXMLEventWriter(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((OutputStream)os);
                }
            };
        }
        return new DelegatingXMLEventWriter(reader);
    }

    public AutoCloseableXMLEventWriter createXMLEventWriter(Result xmlResult) throws XMLStreamException {
        Args.notNull((String)"xmlResult", (Object)xmlResult);
        XMLEventWriter writer = this.xmlOutputFactory.get().createXMLEventWriter(xmlResult);
        return new DelegatingXMLEventWriter(writer);
    }

    public AutoCloseableXMLEventWriter createXMLEventWriter(final StreamResult xmlResult, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlResult", (Object)xmlResult);
        XMLEventWriter writer = this.xmlOutputFactory.get().createXMLEventWriter(xmlResult);
        if (autoClose) {
            return new DelegatingXMLEventWriter(writer){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Writer)xmlResult.getWriter());
                    IOUtils.closeQuietly((OutputStream)xmlResult.getOutputStream());
                }
            };
        }
        return new DelegatingXMLEventWriter(writer);
    }

    public AutoCloseableXMLEventWriter createXMLEventWriter(final Writer xmlWriter, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlWriter", (Object)xmlWriter);
        XMLEventWriter reader = this.xmlOutputFactory.get().createXMLEventWriter(xmlWriter);
        if (autoClose) {
            return new DelegatingXMLEventWriter(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Writer)xmlWriter);
                }
            };
        }
        return new DelegatingXMLEventWriter(reader);
    }

    protected XMLInputFactory createXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        if (factory.isPropertySupported("http://javax.xml.XMLConstants/property/accessExternalDTD")) {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        if (factory.isPropertySupported("http://javax.xml.XMLConstants/property/accessExternalSchema")) {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        if (factory.isPropertySupported("http://javax.xml.XMLConstants/property/accessExternalStylesheet")) {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        return factory;
    }

    protected XMLOutputFactory createXMLOutputFactory() {
        return XMLOutputFactory.newInstance();
    }

    public ExtendedXMLStreamReader createXMLStreamReader(File xmlFile) throws FileNotFoundException, XMLStreamException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Args.isFileReadable((String)"xmlFile", (File)xmlFile);
        final BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlFile));
        XMLStreamReader reader = this.xmlInputFactory.get().createXMLStreamReader(is);
        return new ExtendedXMLStreamReader(reader){

            @Override
            public void close() throws XMLStreamException {
                super.close();
                IOUtils.closeQuietly((InputStream)is);
            }
        };
    }

    public ExtendedXMLStreamReader createXMLStreamReader(InputStream xmlInput, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlInput", (Object)xmlInput);
        final InputStream is = xmlInput instanceof BufferedInputStream ? xmlInput : new BufferedInputStream(xmlInput);
        XMLStreamReader reader = this.xmlInputFactory.get().createXMLStreamReader(is);
        if (autoClose) {
            return new ExtendedXMLStreamReader(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((InputStream)is);
                }
            };
        }
        return new ExtendedXMLStreamReader(reader);
    }

    public ExtendedXMLStreamReader createXMLStreamReader(final Reader xmlReader, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlReader", (Object)xmlReader);
        XMLStreamReader reader = this.xmlInputFactory.get().createXMLStreamReader(xmlReader);
        if (autoClose) {
            return new ExtendedXMLStreamReader(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Reader)xmlReader);
                }
            };
        }
        return new ExtendedXMLStreamReader(reader);
    }

    public ExtendedXMLStreamReader createXMLStreamReader(Source xmlSource) throws XMLStreamException {
        Args.notNull((String)"xmlSource", (Object)xmlSource);
        XMLStreamReader reader = this.xmlInputFactory.get().createXMLStreamReader(xmlSource);
        return new ExtendedXMLStreamReader(reader);
    }

    public ExtendedXMLStreamReader createXMLStreamReader(final StreamSource xmlSource, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlSource", (Object)xmlSource);
        XMLStreamReader reader = this.xmlInputFactory.get().createXMLStreamReader(xmlSource);
        if (autoClose) {
            return new ExtendedXMLStreamReader(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Reader)xmlSource.getReader());
                    IOUtils.closeQuietly((InputStream)xmlSource.getInputStream());
                }
            };
        }
        return new ExtendedXMLStreamReader(reader);
    }

    public ExtendedXMLStreamWriter createXMLStreamWriter(File xmlFile) throws FileNotFoundException, XMLStreamException {
        Args.notNull((String)"xmlFile", (Object)xmlFile);
        Args.isFileWriteable((String)"xmlFile", (File)xmlFile);
        final BufferedOutputStream is = new BufferedOutputStream(new FileOutputStream(xmlFile));
        XMLStreamWriter writer = this.xmlOutputFactory.get().createXMLStreamWriter(is);
        return new ExtendedXMLStreamWriter(writer){

            @Override
            public void close() throws XMLStreamException {
                super.close();
                IOUtils.closeQuietly((OutputStream)is);
            }
        };
    }

    public ExtendedXMLStreamWriter createXMLStreamWriter(OutputStream xmlOutput, Charset encoding, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlOutput", (Object)xmlOutput);
        Args.notNull((String)"encoding", (Object)encoding);
        final OutputStream os = xmlOutput instanceof BufferedOutputStream ? xmlOutput : new BufferedOutputStream(xmlOutput);
        XMLStreamWriter reader = this.xmlOutputFactory.get().createXMLStreamWriter(os, encoding.name());
        if (autoClose) {
            return new ExtendedXMLStreamWriter(reader){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((OutputStream)os);
                }
            };
        }
        return new ExtendedXMLStreamWriter(reader);
    }

    public ExtendedXMLStreamWriter createXMLStreamWriter(Result xmlResult) throws XMLStreamException {
        Args.notNull((String)"xmlResult", (Object)xmlResult);
        XMLStreamWriter writer = this.xmlOutputFactory.get().createXMLStreamWriter(xmlResult);
        return new ExtendedXMLStreamWriter(writer);
    }

    public ExtendedXMLStreamWriter createXMLStreamWriter(final StreamResult xmlResult, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlResult", (Object)xmlResult);
        XMLStreamWriter writer = this.xmlOutputFactory.get().createXMLStreamWriter(xmlResult);
        if (autoClose) {
            return new ExtendedXMLStreamWriter(writer){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Writer)xmlResult.getWriter());
                    IOUtils.closeQuietly((OutputStream)xmlResult.getOutputStream());
                }
            };
        }
        return new ExtendedXMLStreamWriter(writer);
    }

    public ExtendedXMLStreamWriter createXMLStreamWriter(final Writer xmlWriter, boolean autoClose) throws XMLStreamException {
        Args.notNull((String)"xmlWriter", (Object)xmlWriter);
        XMLStreamWriter writer = this.xmlOutputFactory.get().createXMLStreamWriter(xmlWriter);
        if (autoClose) {
            return new ExtendedXMLStreamWriter(writer){

                @Override
                public void close() throws XMLStreamException {
                    super.close();
                    IOUtils.closeQuietly((Writer)xmlWriter);
                }
            };
        }
        return new ExtendedXMLStreamWriter(writer);
    }
}

