/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.architecture.cache;

import net.sf.minuteProject.architecture.cache.UniqueReferenceCache;

public class DomainReferenceCache<T> {
    private final String PK_TO_OBJECT = "PK_TO_OBJECT";
    private final String PK_TO_UK_ = "PK_TO_UK_";
    private final String UK_TO_OBJECT = "UK_TO_OBJECT";
    private final String UK_TO_PK = "UK_TO_PK";
    private UniqueReferenceCache uniqueReferenceCache = new UniqueReferenceCache();

    public void put(T fullObject, T ... key) {
        int size = key.length;
        for (int i = 0; i < size - 1; ++i) {
            this.put(fullObject, key[0], key[i + 1], i + 1);
        }
    }

    public void put(T fullObject, T pkObject, T ukObject, int iteration) {
        if (iteration == 1) {
            this.uniqueReferenceCache.put((Object)pkObject, (Object)"PK_TO_OBJECT", (Object)fullObject);
        }
        this.uniqueReferenceCache.put((Object)pkObject, (Object)this.getPkToUk(iteration), (Object)ukObject);
        this.uniqueReferenceCache.put((Object)ukObject, (Object)"UK_TO_OBJECT", (Object)fullObject);
        this.uniqueReferenceCache.put((Object)ukObject, (Object)"UK_TO_PK", (Object)pkObject);
    }

    public T getObjectByPk(T pkObject) {
        return (T)this.uniqueReferenceCache.get(pkObject, "PK_TO_OBJECT");
    }

    public T getUkByPk(T pkObject, int iteration) {
        return (T)this.uniqueReferenceCache.get(pkObject, this.getPkToUk(iteration));
    }

    public T getObjectByUk(T ukObject) {
        return (T)this.uniqueReferenceCache.get(ukObject, "UK_TO_OBJECT");
    }

    public T getPkByUk(T ukObject) {
        return (T)this.uniqueReferenceCache.get(ukObject, "UK_TO_PK");
    }

    private String getPkToUk(int iteration) {
        return "PK_TO_UK_" + iteration;
    }
}

