/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.architecture.cache;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.minuteProject.architecture.cache.Cache;

public class SimpleCache
implements Cache {
    private Long delay;
    private final long delayDefault = 300000L;
    private final int maxKeyDefault = 100;
    private Integer maxKeys;
    private static Hashtable table = new Hashtable();
    private static Hashtable timeTable = new Hashtable();

    @Override
    public Object get(String key) {
        Date date = (Date)timeTable.get(key);
        if (date != null && new Date().getTime() - date.getTime() > this.getDelay()) {
            timeTable.remove(key);
            if (table.contains(key)) {
                table.remove(key);
            }
            return null;
        }
        return table.get(key);
    }

    @Override
    public void clean() {
        Enumeration keys = timeTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeIfNecessary(key);
        }
    }

    private void removeIfNecessary(String key) {
        Date date = (Date)timeTable.get(key);
        if (date != null && new Date().getTime() - date.getTime() > this.getDelay()) {
            timeTable.remove(key);
            if (table.contains(key)) {
                table.remove(key);
            }
        }
    }

    @Override
    public void put(String key, Object o) {
        if (timeTable.size() > this.getMaxKeys()) {
            this.flush();
        }
        this.putEffective(key, o);
    }

    private void putEffective(String key, Object o) {
        if (key != null && o != null) {
            timeTable.put(key, new Date());
            table.put(key, o);
        }
    }

    @Override
    public void remove(String key) {
        timeTable.remove(key);
        table.remove(key);
    }

    @Override
    public void flush() {
        timeTable.clear();
        table.clear();
    }

    public long getDelay() {
        if (this.delay == null) {
            this.setDelay(300000L);
        }
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    @Override
    public void setRefreshDelay(Long delay) {
        this.setDelay(delay);
    }

    public Integer getMaxKeys() {
        if (this.maxKeys == null) {
            this.setMaxKeys(100);
        }
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }
}

