/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.architecture.cache;

import java.util.Date;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.collections.map.MultiKeyMap;

public class UniqueReferenceCache {
    private Long delay;
    private final long delayDefault = 300000L;
    private final int maxKeyDefault = 100;
    private Integer maxKeys;
    private static MultiKeyMap table = new MultiKeyMap();
    private static MultiKeyMap timeTable = new MultiKeyMap();

    public Object get(Object pkObject, Object ukObject) {
        Date date = (Date)timeTable.get(pkObject, ukObject);
        if (date != null && new Date().getTime() - date.getTime() > this.getDelay()) {
            timeTable.remove(pkObject, ukObject);
            if (table.containsKey(pkObject, ukObject)) {
                table.remove(pkObject, ukObject);
            }
            return null;
        }
        return table.get(pkObject, ukObject);
    }

    public void clean() {
        MapIterator iter = timeTable.mapIterator();
        while (iter.hasNext()) {
            MultiKey keys = (MultiKey)iter.next();
            this.removeIfNecessary(keys.getKey(0), keys.getKey(1));
        }
    }

    private void removeIfNecessary(Object pkObject, Object ukObject) {
        Date date = (Date)timeTable.get(pkObject, ukObject);
        if (date != null && new Date().getTime() - date.getTime() > this.getDelay()) {
            timeTable.remove(pkObject, ukObject);
            if (table.containsKey(pkObject, ukObject)) {
                table.remove(pkObject, ukObject);
            }
        }
    }

    public void put(Object fullObject, Object ... key) {
        this.put(key[0], key[1], fullObject);
    }

    public void put(Object pkObject, Object ukObject, Object fullObject) {
        if (timeTable.size() > this.getMaxKeys()) {
            this.flush();
        }
        this.putEffective(pkObject, ukObject, fullObject);
    }

    private void putEffective(Object pkObject, Object ukObject, Object fullObject) {
        timeTable.put(pkObject, ukObject, (Object)new Date());
        table.put(pkObject, ukObject, fullObject);
    }

    public void put(Object ... key) {
        this.remove(key[0], key[1]);
    }

    public void remove(Object pkObject, Object ukObject) {
        timeTable.remove(pkObject, ukObject);
        table.remove(pkObject, ukObject);
    }

    public void flush() {
        timeTable.clear();
        table.clear();
    }

    public long getDelay() {
        if (this.delay == null) {
            this.setDelay(300000L);
        }
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public void setRefreshDelay(Long delay) {
        this.setDelay(delay);
    }

    public Integer getMaxKeys() {
        if (this.maxKeys == null) {
            this.setMaxKeys(100);
        }
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }
}

