/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.architecture.validation.model;

import net.sf.minuteProject.architecture.holder.element.ValidationModelError;

public class AbstractModelValidator {
    protected ValidationModelError validateMaxLength(String fieldName, String fieldValue, int acceptedLength) {
        if (fieldValue != null) {
            int fieldLength = fieldValue.length();
            return this.validateMaxLength(fieldName, fieldLength, acceptedLength);
        }
        return null;
    }

    protected ValidationModelError validateMaxLength(String fieldName, int fieldLength, int acceptedLength) {
        if (fieldLength > acceptedLength) {
            return new ValidationModelError("LENGTH_TOO_HIGH", fieldName, fieldLength, acceptedLength);
        }
        return null;
    }

    protected ValidationModelError validateMaxLength(String fieldName, long fieldLength, long acceptedLength) {
        if (fieldLength > acceptedLength) {
            return new ValidationModelError("LENGTH_TOO_HIGH", fieldName, fieldLength, acceptedLength);
        }
        return null;
    }

    protected ValidationModelError validatePresence(String fieldName, Object fieldValue, boolean isTobePresent) {
        if (isTobePresent && fieldValue == null) {
            return new ValidationModelError("ABSENT", fieldName);
        }
        return null;
    }

    protected ValidationModelError validatePresence(String fieldName, String fieldValue, boolean isTobePresent) {
        if (isTobePresent && (fieldValue == null || fieldValue.equals(""))) {
            return new ValidationModelError("ABSENT", fieldName);
        }
        return null;
    }
}

