/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.model.dao;

import java.util.List;
import net.sf.minuteProject.architecture.bsla.domain.AbstractDomainObject;
import net.sf.minuteProject.model.dao.GenericDao;
import net.sf.minuteProject.model.data.criteria.EntityCriteria;
import net.sf.minuteProject.model.data.criteria.EntitySort;
import net.sf.minuteProject.model.data.criteria.QueryData;
import net.sf.minuteProject.model.data.criteria.constant.EntityMatchType;
import net.sf.minuteProject.model.data.criteria.constant.OperandType;
import net.sf.minuteProject.model.data.criteria.constant.QuerySortOrder;
import net.sf.minuteProject.model.utils.BuilderUtils;

public abstract class GenericDaoImpl<T extends AbstractDomainObject>
implements GenericDao<T> {
    @Override
    public void findWithoutCount(QueryData<T> data) {
        EntityCriteria<T> filter = data.getEntityCriteria();
        T entityWhat = data.getEntityWhat();
        T criteriaMask = filter.getEntity();
        Integer start = data.getStart();
        Integer max = data.getMax();
        EntitySort<T> entitySort = data.getEntitySort();
        QuerySortOrder sortOrder = entitySort.getOrder();
        AbstractDomainObject sortMask = (AbstractDomainObject)entitySort.getEntity();
        List<AbstractDomainObject> results = this.find(entityWhat, criteriaMask, sortMask, filter.getMatchType(), filter.getOperandType(), filter.getCaseSensitivenessType(), sortOrder, start, max);
        data.setResult(results);
    }

    @Override
    public void find(QueryData<T> data) {
        this.findWithoutCount(data);
        T entityWhat = data.getEntityWhat();
        EntityCriteria<T> filter = data.getEntityCriteria();
        T criteriaMask = filter.getEntity();
        Integer max = data.getMax();
        List<T> results = data.getResult();
        int size = results.size();
        if (size < max) {
            data.setTotalResultCount(Long.valueOf(size));
        } else {
            data.setTotalResultCount(this.count(entityWhat, criteriaMask, filter.getMatchType(), filter.getOperandType(), filter.getCaseSensitivenessType()));
        }
    }

    protected abstract Long count(T var1, T var2, EntityMatchType var3, OperandType var4, Boolean var5);

    protected abstract List<T> find(T var1, T var2, T var3, EntityMatchType var4, OperandType var5, Boolean var6, QuerySortOrder var7, Integer var8, Integer var9);

    protected String getWhereEqualAnyWhereQueryChunk(T t, boolean isAndSet) {
        return this.getSearchEqualWhereQueryChunk(t, isAndSet, false);
    }

    protected String getWhereEqualWhereQueryChunk(T t, boolean isAndSet) {
        return this.getSearchEqualWhereQueryChunk(t, isAndSet, true);
    }

    public List<T> searchPrototypeCategory(T t) {
        return this.searchPrototype(t, null);
    }

    protected List<T> searchPrototype(T t, Integer maxResults) {
        return this.searchPrototype(t, null, null, maxResults);
    }

    protected List<T> searchPrototype(T t, T orderMask, QuerySortOrder sortOrder, Integer maxResults) {
        return this.searchPrototype(this.getSelectQuery(this.getWhereEqualWhereQueryChunk(t), orderMask, sortOrder), maxResults);
    }

    protected String getSelectQuery(String where, T orderMask, QuerySortOrder sortOrder) {
        return this.getSelectQuery(where, this.findOrder(orderMask, sortOrder));
    }

    protected String getSelectQuery(String where, String order) {
        StringBuffer query = new StringBuffer();
        query.append(this.getSelectFrom());
        return BuilderUtils.getHQuery(query.toString(), where, order);
    }

    protected String getWhereEqualWhereQueryChunk(T t) {
        return this.getWhereEqualWhereQueryChunk(t, false);
    }

    protected abstract String getSelectFrom();

    protected abstract boolean isAllNull(T var1);

    protected abstract String getSearchEqualWhereQueryChunk(T var1, boolean var2, boolean var3);

    protected abstract String findWhere(T var1, boolean var2, boolean var3, OperandType var4, Boolean var5);

    protected abstract String findOrder(T var1, QuerySortOrder var2);

    protected abstract List<T> searchPrototype(String var1, Integer var2);

    protected abstract T assignBlankToNull(T var1);
}

