/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.model.dao.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.minuteProject.architecture.bsla.domain.AbstractDomainObject;
import net.sf.minuteProject.model.dao.GenericDaoImpl;
import net.sf.minuteProject.model.data.criteria.constant.EntityMatchType;
import net.sf.minuteProject.model.data.criteria.constant.OperandType;
import net.sf.minuteProject.model.data.criteria.constant.QuerySortOrder;

public abstract class GenericDaoJpaImpl<T extends AbstractDomainObject>
extends GenericDaoImpl<T> {
    @Override
    public void save(T t) {
        this.getEntityManager().persist(t);
    }

    @Override
    public void delete(T t) {
        this.getEntityManager().remove(t);
    }

    @Override
    public void insert(T t) {
        this.getEntityManager().persist(t);
    }

    @Override
    public void insert(List<T> list) {
        for (AbstractDomainObject element : list) {
            this.insert(element);
        }
    }

    @Override
    public T update(T t) {
        this.getEntityManager().merge(t);
        return t;
    }

    @Override
    protected List<T> searchPrototype(String query, Integer maxResults) {
        Query hquery = this.getEntityManager().createQuery(query);
        if (maxResults != null) {
            hquery.setMaxResults(maxResults.intValue());
        }
        return hquery.getResultList();
    }

    public abstract EntityManager getEntityManager();

    public abstract void setEntityManager(EntityManager var1);

    public Long count(T t, EntityMatchType matchType, OperandType operandType, Boolean caseSensitivenessType) {
        Query query = this.getEntityManager().createQuery(this.countQuery(t, matchType, operandType, caseSensitivenessType));
        List list = query.getResultList();
        if (!list.isEmpty()) {
            return (Long)list.get(0);
        }
        return 0L;
    }

    protected String countQuery(T t, EntityMatchType matchType, OperandType operandType, Boolean caseSensitivenessType) {
        String what = this.getQuerySelectFromEntity();
        return this.findQuery(t, null, what, matchType, operandType, caseSensitivenessType, null);
    }

    private String findQuery(T t, T orderMask, String what, EntityMatchType matchType, OperandType operandType, Boolean caseSensitivenessType, QuerySortOrder sortOrder) {
        return null;
    }

    protected abstract String getQuerySelectFromEntity();
}

