/*
 * Decompiled with CFR 0.152.
 */
package net.sf.minuteProject.model.data.criteria;

import java.util.List;
import net.sf.minuteProject.architecture.bsla.domain.AbstractDomainObject;
import net.sf.minuteProject.model.data.criteria.EntityCriteria;
import net.sf.minuteProject.model.data.criteria.EntitySort;

public class QueryData<T extends AbstractDomainObject> {
    private List<T> result;
    private Long totalResultCount;
    private final Integer start;
    private final Integer max;
    private final EntitySort<T> entitySort;
    private final EntityCriteria<T> entityCriteria;
    private T entityWhat;

    public QueryData(Integer start, Integer max, EntitySort<T> entitySort, EntityCriteria<T> entityCriteria, T entityWhat) {
        this(start, max, entitySort, entityCriteria);
        this.entityWhat = entityWhat;
    }

    public QueryData(Integer start, Integer max, EntitySort<T> entitySort, EntityCriteria<T> entityCriteria) {
        this.start = start;
        this.max = max;
        this.entitySort = entitySort;
        this.entityCriteria = entityCriteria;
    }

    public Boolean needsNewCount(QueryData<T> queryData) {
        if (queryData == null || queryData.getEntityCriteria() == null || queryData.getEntityCriteria().getEntity() == null || this.getEntityCriteria() == null) {
            return true;
        }
        return this.areEntityCriteriaSimilar(queryData) == false;
    }

    private Boolean areEntityCriteriaSimilar(QueryData<T> queryData) {
        return ((AbstractDomainObject)queryData.getEntityCriteria().getEntity()).equalsMask(this.getEntityCriteria().getEntity()) && (queryData.getEntityWhat() == null && this.entityWhat == null || ((AbstractDomainObject)queryData.getEntityWhat()).equalsMask(this.entityWhat));
    }

    public List<T> getResult() {
        return this.result;
    }

    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    public int getStart() {
        return this.start;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public void setTotalResultCount(Long totalResultCount) {
        this.totalResultCount = totalResultCount;
    }

    public int getMax() {
        return this.max;
    }

    public EntitySort<T> getEntitySort() {
        return this.entitySort;
    }

    public EntityCriteria<T> getEntityCriteria() {
        return this.entityCriteria;
    }

    public T getEntityWhat() {
        return this.entityWhat;
    }

    public String toString() {
        return "QueryData [start=" + this.start + ", end=" + this.max + ", entitySort=" + this.entitySort + ", entityCriteria=" + this.entityCriteria + ", entityWhat= " + this.entityWhat + "]";
    }
}

