/*---------------------------------------------------------------------------
 * 2005 NORSYS
 * main author : nono
 *
 * This software is a computer program whose purpose is to provide abstraction
 * for accessing directory data sources within java applications.
 *
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * Created on Oct 19, 2005
 * --------------------------------------------------------------------------*/
package speculoos.commons.mockldap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

/**
 * This class parses a LDIF file and constructs a graph of TestDirContext
 * objects in memory. A LDIF file as the following format:
 * <ul>
 * <li>each line is an attribute /value pair separated by colon </li>
 * <li>each entry starts with a dn attribute and ends with an empty line </li>
 * </ul>
 * 
 * @author nono
 * @version $Id: LDIFParser.java 26 2006-07-28 14:52:30Z trecloux $
 */
public class LDIFParser {

    private Properties nameSyntax = TestDirContext.SYNTAX;

    private int entryCount;

    /**
     * Parse a LDIF formatetted input Stream. This parser assumes all key/value
     * pairs are on ONE line.
     * 
     * @param is
     * @return
     * @throws IOException
     * @throws NamingException
     */
    public TestDirContext parse(InputStream is) throws IOException,
            NamingException {
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        String line = null;
        TestDirContext entry = null;
        TestDirContext root = null;
        Attribute cur = null;
        int ln = 0;
        String name = null;
        while ((line = rd.readLine()) != null) {
            ln++;
            /* normalize */
            line = line.trim();
            if (!"".equals(line)) {
                /* split attribute/value */
                String[] kv = line.split(":");
                if (kv.length == 1) {
                    /* a continuated attribute value */
                    if (cur == null)
                        // throw new IOException("File format error : non
                        // attribute value at line "+ln);
                        continue;
                    /* append value */
                    String s = (String) cur.remove(0);
                    cur.add(s + kv[0].trim());
                    continue;
                }
                if ("dn".equals(kv[0])) {
                    /* compute name of entry */
                	name = kv[1].trim();
                    Name nam = new CompoundName(kv[1].trim(), nameSyntax);
                    /* find parent */
                    if (root == null)
                        entry = root = new TestDirContext(nam, null);
                    else
                        entry = (TestDirContext) root.createSubcontext(nam);
                    entryCount++;
                    cur = null;
                } else if ("ACL".equals(kv[0])) {
                    /* ignore ACL */
                    continue;
                } else {
                    /*
                     * if attribute is already defined add a new attribute to
                     * list
                     */
                	if (cur != null) {
                        /* add current accumulated attribute to node */
                        Attributes attrs = entry.getAttributes("");
                        Attribute attr = attrs.get(cur.getID());
                        if (attr == null) {
                            attr = cur;
                            attrs.put(attr);
                        } else
                            attr.add(cur.get());
                    }
                    /* reset cur */
                    String attName = kv[0].trim();
                    if ("objectClass".equals(attName)) {
                    	attName = attName.toLowerCase();
                    }
                    cur = new BasicAttribute(attName);
                    cur.add(kv[1].trim());
                }
            } else {
                if (cur != null) {
                    /* add current accumulated attribute to node */
                    Attributes attrs = entry.getAttributes("");
                    Attribute attr = attrs.get(cur.getID());
                    if (attr == null) {
                        attr = cur;
                        attrs.put(attr);
                    } else
                        attr.add(cur.get());
                }

            }
        }
        return root;
    }

    /**
     * @return Returns the entryCount.
     */
    public int getEntryCount() {
        return entryCount;
    }

    /**
     * @param entryCount The entryCount to set.
     */
    public void setEntryCount(int entryCount) {
        this.entryCount = entryCount;
    }
}
