/**
 * 
 */
package speculoos.commons.mockldap;

import java.util.Iterator;
import java.util.List;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/**
 * Basic implementation of NamingEnumeration interface.
 * 
 * @author nono
 * @version $Id: ListEnum.java 21 2006-07-19 07:28:18Z trecloux $
 */
public class ListEnum implements NamingEnumeration {

    private Iterator iterator;

    public ListEnum(List l) {
        this.iterator = l.iterator();
    }

    public Object next() throws NamingException {
        return iterator.next();
    }

    public boolean hasMore() throws NamingException {
        return iterator.hasNext();
    }

    public void close() throws NamingException {
        iterator = null;
    }

    public boolean hasMoreElements() {
        return iterator.hasNext();
    }

    public Object nextElement() {
        return iterator.next();
    }

}