/*---------------------------------------------------------------------------
 * 2005 NORSYS
 * main author : nono
 *
 * This software is a computer program whose purpose is to provide abstraction
 * for accessing directory data sources within java applications.
 *
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * Created on Oct 20, 2005
 * --------------------------------------------------------------------------*/
package speculoos.commons.mockldap;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

class MatchFilter extends Filter {

    private String name;
    private Object value;
    MatchFilter(Attribute attr) throws NamingException {
        this.name = attr.getID();
        // TODO: handle multiple values
        this.value = attr.get();
    }

    public boolean match(TestDirContext ctx) throws NamingException {
        Attribute attr = ctx.getAttributes("",new String[]{name}).get(name);
        if(attr == null)
            return false;
        /* check object */
        for(NamingEnumeration e = attr.getAll();e.hasMore();) {
        	Object val = e.next();
        	if (val instanceof String) {
        		if (((String)val).equalsIgnoreCase((String) value)) {
        			return true;
        		}
			} else if(val.equals(value))
                return true;
        }
        return false;
    }

}
