/*---------------------------------------------------------------------------
 * 2005 NORSYS
 * main author : nono
 *
 * This software is a computer program whose purpose is to provide abstraction
 * for accessing directory data sources within java applications.
 *
 * This software is governed by the CeCILL  license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 *
 * Created on Oct 19, 2005
 * --------------------------------------------------------------------------*/
package speculoos.commons.mockldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author nono
 * @version $Id: TestDirContext.java 26 2006-07-28 14:52:30Z trecloux $
 */
public class TestDirContext implements DirContext, NameParser {

    public static final Properties SYNTAX = new Properties();

    private static final Log log = LogFactory.getLog(TestDirContext.class);

    static {
        SYNTAX.put("jndi.syntax.direction", "right_to_left");
        SYNTAX.put("jndi.syntax.separator", ",");
        SYNTAX.put("jndi.syntax.ignorecase", "true");
        SYNTAX.put("jndi.syntax.trimblanks", "true");
        SYNTAX.put("jndi.syntax.separator.ava", ",");
        SYNTAX.put("jndi.syntax.separator.typeval", "=");
    }

    private Name name;
    
    private BasicAttributes attributes = new BasicAttributes();
    private TestDirContext parent;    

    private Map children = new HashMap();


    /**
     * Only used for root context.
     * 
     * @param nam
     */
    public TestDirContext(Name nam, TestDirContext parent) {
        this.name = nam;
        this.parent = parent;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getAttributes(javax.naming.Name)
     */
    public Attributes getAttributes(Name name) throws NamingException {
        if (name.size() <= 1)
            return this.attributes;
        /* find context */
        Name child = name.getPrefix(2).getSuffix(1);
        Name descendant = name.getSuffix(1);
        DirContext ctx = (DirContext) children.get(child);
        if (ctx == null)
            throw new NamingException("Cannot resolve name " + name);
        return ctx.getAttributes(descendant);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getAttributes(java.lang.String)
     */
    public Attributes getAttributes(String name) throws NamingException {
        return getAttributes(makeName(name));
    }

    private Name makeName(String n) throws InvalidNameException {
        return new CompoundName(n, SYNTAX);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getAttributes(javax.naming.Name,
     *      java.lang.String[])
     */
    public Attributes getAttributes(Name name, String[] attrIds)
            throws NamingException {
    	Attributes attrs;
    	if (attrIds == null) {
	        attrs = getAttributes(name);
    	} else {
    		attrs = new BasicAttributes();
	        Set atns = new HashSet(Arrays.asList(attrIds));	        
	        for (NamingEnumeration e = getAttributes(name).getAll(); e.hasMore();) {
	            Attribute attr = (Attribute) e.next();
	            if (atns.contains(attr.getID()))
	                attrs.put(attr);
	        }
    	}
        return attrs;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getAttributes(java.lang.String,
     *      java.lang.String[])
     */
    public Attributes getAttributes(String name, String[] attrIds)
            throws NamingException {
        return getAttributes(makeName(name), attrIds);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#modifyAttributes(javax.naming.Name,
     *      int, javax.naming.directory.Attributes)
     */
    public void modifyAttributes(Name name, int mod_op, Attributes attrs)
            throws NamingException {
    	throw new NamingException("Unsuported operation");    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#modifyAttributes(java.lang.String,
     *      int, javax.naming.directory.Attributes)
     */
    public void modifyAttributes(String name, int mod_op, Attributes attrs)
            throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#modifyAttributes(javax.naming.Name,
     *      javax.naming.directory.ModificationItem[])
     */
    public void modifyAttributes(Name name, ModificationItem[] mods)
            throws NamingException {
    	
    	if (name.size() == 1) {
    		modify(mods);        	
        } else if (name.size() > 1) {
            /* find context */
        	Name child = name.getPrefix(2).getSuffix(1);
            Name descendant = name.getSuffix(1);
            DirContext ctx = (DirContext) children.get(child);
            if (ctx == null)
                throw new NamingException("Cannot resolve name " + name);
            ctx.modifyAttributes(descendant, mods);
        } else {
            throw new NamingException(
                    "Invalid empty name for creating subcontext");
        }

    }
    
    private void modify(ModificationItem[] mods) throws NamingException {
    	for (int i=0; i< mods.length; i++) {
    		ModificationItem item = mods[i];
    		switch (item.getModificationOp()) {
			case DirContext.REPLACE_ATTRIBUTE:
				Attribute attr2modify = attributes.get(item.getAttribute().getID());
			    if (attr2modify == null) {
			    	// l'attribut n'existe pas, il faut le crer
			    	if (item.getAttribute().size() > 1) {
			    		attr2modify = new BasicAttribute(item.getAttribute().getID());
			    		for (int j = 0; j < item.getAttribute().size(); j++) {
							attr2modify.add(item.getAttribute().get(j));
						}
			    	} else {
			    		attr2modify = new BasicAttribute(item.getAttribute().getID(), item.getAttribute().get());
			    	}
			    	attributes.put(attr2modify);
			    } else {
			    	// changer la valeur de l'attribut
			    	attr2modify.clear();
			    	if (item.getAttribute().size() > 1) {				    	
				    	for (int j = 0; j < item.getAttribute().size(); j++) {
							attr2modify.add(item.getAttribute().get(j));
						}
			    	} else {
			    		attr2modify.add(item.getAttribute().get());
			    	}
			    }
				break;
			case DirContext.ADD_ATTRIBUTE:
				attr2modify = attributes.get(item.getAttribute().getID());
		        if (attr2modify == null) {
			    	// l'attribut n'existe pas, il faut le crer
			    	if (item.getAttribute().size() > 1) {
			    		attr2modify = new BasicAttribute(item.getAttribute().getID());
			    		for (int j = 0; j < item.getAttribute().size(); j++) {
							attr2modify.add(item.getAttribute().get(j));
						}
			    	} else {
			    		attr2modify = new BasicAttribute(item.getAttribute().getID(), item.getAttribute().get());
			    	}
			    	attributes.put(attr2modify);
			    } else {
			    	for (int j = 0; j < item.getAttribute().size(); j++) {
						attr2modify.add(item.getAttribute().get(j));
					}
			    }
		        break;
			case DirContext.REMOVE_ATTRIBUTE:
				throw new NamingException("Unsuported operation");
			}
			
    	}
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#modifyAttributes(java.lang.String,
     *      javax.naming.directory.ModificationItem[])
     */
    public void modifyAttributes(String name, ModificationItem[] mods)
            throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#bind(javax.naming.Name,
     *      java.lang.Object, javax.naming.directory.Attributes)
     */
    public void bind(Name name, Object obj, Attributes attrs)
            throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#bind(java.lang.String,
     *      java.lang.Object, javax.naming.directory.Attributes)
     */
    public void bind(String name, Object obj, Attributes attrs)
            throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#rebind(javax.naming.Name,
     *      java.lang.Object, javax.naming.directory.Attributes)
     */
    public void rebind(Name name, Object obj, Attributes attrs)
            throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#rebind(java.lang.String,
     *      java.lang.Object, javax.naming.directory.Attributes)
     */
    public void rebind(String name, Object obj, Attributes attrs)
            throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#createSubcontext(javax.naming.Name,
     *      javax.naming.directory.Attributes)
     */
    public DirContext createSubcontext(Name name, Attributes attrs)
            throws NamingException {
        if (name.size() == 2) {
        	return appendContext(name.getSuffix(1), attrs);
        } else if (name.size() > 2) {
            /* find context */
        	Name child = name.getPrefix(2).getSuffix(1);
            Name descendant = name.getSuffix(1);
            DirContext ctx = (DirContext) children.get(child);
            if (ctx == null)
                throw new NamingException("Cannot resolve name " + name);
            return ctx.createSubcontext(descendant, attrs);
        } else {
            throw new NamingException(
                    "Invalid empty name for creating subcontext");
        }
    }
    
    private DirContext appendContext(Name name, Attributes attrs)  throws NamingException {
    	TestDirContext tcd = new TestDirContext(name, this);
        children.put(name, tcd);
        for (NamingEnumeration e = attrs.getAll(); e.hasMore();) {
            tcd.attributes.put((Attribute) e.next());
        }
        return tcd;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#createSubcontext(java.lang.String,
     *      javax.naming.directory.Attributes)
     */
    public DirContext createSubcontext(String name, Attributes attrs)
            throws NamingException {
        return createSubcontext(makeName(name), attrs);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getSchema(javax.naming.Name)
     */
    public DirContext getSchema(Name name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getSchema(java.lang.String)
     */
    public DirContext getSchema(String name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getSchemaClassDefinition(javax.naming.Name)
     */
    public DirContext getSchemaClassDefinition(Name name)
            throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#getSchemaClassDefinition(java.lang.String)
     */
    public DirContext getSchemaClassDefinition(String name)
            throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(javax.naming.Name,
     *      javax.naming.directory.Attributes, java.lang.String[])
     */
    public NamingEnumeration search(Name name, Attributes matchingAttributes,
            String[] attributesToReturn) throws NamingException {
        DirContext dc = (DirContext) lookup(name);
        /*
         * search parameters long lim = cons.getCountLimit(); String[] fa =
         * cons.getReturningAttributes(); long timeout = cons.getTimeLimit();
         */
        Filter flt = Filter.makeFilter(matchingAttributes);
        int scope = SearchControls.ONELEVEL_SCOPE;
        List l = new ArrayList();
        switch (scope) {
        case SearchControls.OBJECT_SCOPE:
            /* simple case */
            if (flt.match(this))
                l.add(this.getAttributes("", attributesToReturn));
            break;
        case SearchControls.ONELEVEL_SCOPE:
            /* look in children */
            for (Iterator i = children.values().iterator(); i.hasNext();) {
                TestDirContext tcd = (TestDirContext) i.next();
                if (flt.match(tcd))
                    l.add(tcd.getAttributes("", attributesToReturn));
            }
            break;
        case SearchControls.SUBTREE_SCOPE:
            throw new NamingException("Does not handle tree scope");
        }
        return new ListEnum(l);
    }

    /*
	 * (non-Javadoc)
	 * 
	 * @see javax.naming.directory.DirContext#search(java.lang.String,
	 *      javax.naming.directory.Attributes, java.lang.String[])
	 */
    public NamingEnumeration search(String name, Attributes matchingAttributes,
            String[] attributesToReturn) throws NamingException {
        return search(new CompoundName(name, SYNTAX), matchingAttributes,
                attributesToReturn);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(javax.naming.Name,
     *      javax.naming.directory.Attributes)
     */
    public NamingEnumeration search(Name name, Attributes matchingAttributes)
            throws NamingException {
        return search(name, matchingAttributes, null);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(java.lang.String,
     *      javax.naming.directory.Attributes)
     */
    public NamingEnumeration search(String name, Attributes matchingAttributes)
            throws NamingException {
        return search(new CompoundName(name, SYNTAX), matchingAttributes, null);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(javax.naming.Name,
     *      java.lang.String, javax.naming.directory.SearchControls)
     */
    public NamingEnumeration search(Name name, String filter,
            SearchControls cons) throws NamingException {
        if (name.size() > 1) {
            /* recurse */
            /* find context */
            Name child = name.getPrefix(2).getSuffix(1);
            Name descendant = name.getSuffix(1);
            DirContext ctx = (DirContext) children.get(child);
            if (ctx == null)
                throw new NamingException("Cannot resolve name " + name);
            return ctx.search(descendant, filter, cons);
        }
        /* search parameters */
        final long lim = cons.getCountLimit() == 0 ? Long.MAX_VALUE : cons
                .getCountLimit();
        final String[] fa = cons.getReturningAttributes();
        final int scope = cons.getSearchScope();
        final long timeout = cons.getTimeLimit();
        /* construct filter */
        final Filter flt = Filter.parse(filter);
        final List l = new ArrayList();
        if (timeout > 0) {
            /* put search in a thread and wait until timeout triggers */
            Thread th = new Thread("search") {
                public void run() {
                    try {
                        doSearch(lim, fa, scope, flt, l);
                    } catch (NamingException e) {
                        log.error("Error while waiting for search completion",
                                e);
                    }
                };
            };
            try {
                /* start working */
                th.start();
                /* sleep */
                Thread.sleep(timeout);
            } catch (InterruptedException ie) {
                log
                        .warn("Search thread interrupted while waiting for search completion");
            }
        } else
            doSearch(lim, fa, scope, flt, l);
        return new ListEnum(l);
    }

    /**
     * @param lim
     * @param fa
     * @param scope
     * @param flt
     * @param l
     *            List to fill with answers
     * @return
     * @throws NamingException
     */
    private List doSearch(long lim, String[] fa, int scope, Filter flt, List l)
            throws NamingException {
        /* for storing result */
        switch (scope) {
        case SearchControls.OBJECT_SCOPE:
            /* simple case */
            if (flt.match(this))
                l.add(new SearchResult(getAbsoluteName(), this, this.getAttributes("", fa), false));
            break;
        case SearchControls.ONELEVEL_SCOPE:
            /* look in children */
            for (Iterator i = children.values().iterator(); i.hasNext();) {
                TestDirContext tcd = (TestDirContext) i.next();
                if (flt.match(tcd))
                    l.add(new SearchResult(tcd.getAbsoluteName(), tcd, tcd
                            .getAttributes("", fa), false));
                if (--lim == 0)
                    break;
            }
            break;
        case SearchControls.SUBTREE_SCOPE:          
        	/* first make a one level search on this node */
        	l = doSearch(lim, fa, SearchControls.ONELEVEL_SCOPE, flt, l);
    		/* subtree search on all childs */
    		Iterator i = children.values().iterator();
    		while (i.hasNext() && l.size() < lim) {
                TestDirContext tcd = (TestDirContext) i.next();
                tcd.doSearch(lim - l.size(), fa, SearchControls.SUBTREE_SCOPE, flt, l);
        	}
        }
        return l;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(java.lang.String,
     *      java.lang.String, javax.naming.directory.SearchControls)
     */
    public NamingEnumeration search(String name, String filter,
            SearchControls cons) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(javax.naming.Name,
     *      java.lang.String, java.lang.Object[],
     *      javax.naming.directory.SearchControls)
     */
    public NamingEnumeration search(Name name, String filterExpr,
            Object[] filterArgs, SearchControls cons) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.directory.DirContext#search(java.lang.String,
     *      java.lang.String, java.lang.Object[],
     *      javax.naming.directory.SearchControls)
     */
    public NamingEnumeration search(String name, String filterExpr,
            Object[] filterArgs, SearchControls cons) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#lookup(javax.naming.Name)
     */
    public Object lookup(Name name) throws NamingException {
        if (name.size() == 1)
            return this;
        if (name.size() > 1) {
            /* recurse */
            /* find context */
            Name child = name.getPrefix(2).getSuffix(1);
            Name descendant = name.getSuffix(1);
            DirContext ctx = (DirContext) children.get(child);
            if (ctx == null)
                throw new NamingException("Cannot resolve name " + name);
            return ctx.lookup(descendant);
        }
        throw new NamingException(
                "Number of components in name is negative ?????");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#lookup(java.lang.String)
     */
    public Object lookup(String name) throws NamingException {
        return lookup(new CompoundName(name, SYNTAX));
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#bind(javax.naming.Name, java.lang.Object)
     */
    public void bind(Name name, Object obj) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#bind(java.lang.String, java.lang.Object)
     */
    public void bind(String name, Object obj) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#rebind(javax.naming.Name, java.lang.Object)
     */
    public void rebind(Name name, Object obj) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#rebind(java.lang.String, java.lang.Object)
     */
    public void rebind(String name, Object obj) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#unbind(javax.naming.Name)
     */
    public void unbind(Name name) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#unbind(java.lang.String)
     */
    public void unbind(String name) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#rename(javax.naming.Name, javax.naming.Name)
     */
    public void rename(Name oldName, Name newName) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#rename(java.lang.String, java.lang.String)
     */
    public void rename(String oldName, String newName) throws NamingException {
    	throw new NamingException("Unsuported operation");

    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#list(javax.naming.Name)
     */
    public NamingEnumeration list(Name name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#list(java.lang.String)
     */
    public NamingEnumeration list(String name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#listBindings(javax.naming.Name)
     */
    public NamingEnumeration listBindings(Name name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#listBindings(java.lang.String)
     */
    public NamingEnumeration listBindings(String name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#destroySubcontext(javax.naming.Name)
     */
    public void destroySubcontext(Name name) throws NamingException {
    	if (name.size() == 2) {
        	children.remove(name.getPrefix(1));
        } else if (name.size() > 2) {
            /* find context */
        	Name child = name.getPrefix(2).getSuffix(1);
            Name descendant = name.getSuffix(1);
            DirContext ctx = (DirContext) children.get(child);
            if (ctx == null)
                throw new NamingException("Cannot resolve name " + name);
            ctx.destroySubcontext(descendant);
        } else {
            throw new NamingException(
                    "Invalid empty name for destoying subcontext");
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#destroySubcontext(java.lang.String)
     */
    public void destroySubcontext(String name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#createSubcontext(javax.naming.Name)
     */
    public Context createSubcontext(Name name) throws NamingException {
        return createSubcontext(name, new BasicAttributes());
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#createSubcontext(java.lang.String)
     */
    public Context createSubcontext(String name) throws NamingException {
        return createSubcontext(name, new BasicAttributes());
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#lookupLink(javax.naming.Name)
     */
    public Object lookupLink(Name name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#lookupLink(java.lang.String)
     */
    public Object lookupLink(String name) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#getNameParser(javax.naming.Name)
     */
    public NameParser getNameParser(Name name) throws NamingException {
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#getNameParser(java.lang.String)
     */
    public NameParser getNameParser(String name) throws NamingException {
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#composeName(javax.naming.Name,
     *      javax.naming.Name)
     */
    public Name composeName(Name name, Name prefix) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#composeName(java.lang.String, java.lang.String)
     */
    public String composeName(String name, String prefix)
            throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#addToEnvironment(java.lang.String,
     *      java.lang.Object)
     */
    public Object addToEnvironment(String propName, Object propVal)
            throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#removeFromEnvironment(java.lang.String)
     */
    public Object removeFromEnvironment(String propName) throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#getEnvironment()
     */
    public Hashtable getEnvironment() throws NamingException {
    	throw new NamingException("Unsuported operation");
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#close()
     */
    public void close() throws NamingException {
        /* remove all subcontext */
//        this.children = null;
//        this.attributes = null;
//        if (log.isDebugEnabled())
//            log.debug("Closing context " + name);
//        this.name = null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.naming.Context#getNameInNamespace()
     */
    public String getNameInNamespace() throws NamingException {
        return name.toString();
    }

    public Name parse(String name) throws NamingException {
        return new CompoundName(name, SYNTAX);
    }
    
    private String getAbsoluteName() {
    	if (parent != null) {
    		return name.toString() + "," + parent.getAbsoluteName();
    	} else {
    		return name.toString();
    	}
    }

}
