/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.io.Serializable;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.ProtoMonad;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.defs.partial.ContainsAware;
import net.sf.staccatocommons.defs.partial.SizeAware;
import net.sf.staccatocommons.lang.None;
import net.sf.staccatocommons.lang.Some;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class Option<A>
implements Thunk<A>,
Iterable<A>,
SizeAware,
ContainsAware<A>,
ProtoMonad<Option, A>,
Serializable {
    private static final long serialVersionUID = -4635925023376621559L;

    Option() {
    }

    public abstract A value() throws NoSuchElementException;

    public abstract boolean isDefined();

    public boolean isUndefined() {
        return !this.isDefined();
    }

    public final <T2> Option<T2> map(Applicable<? super A, ? extends T2> function) {
        if (this.isDefined()) {
            return Option.some(function.apply(this.value()));
        }
        return Option.none();
    }

    public final Option<A> filter(Evaluable<? super A> predicate) {
        if (this.isDefined() && predicate.eval(this.value())) {
            return this;
        }
        return Option.none();
    }

    @Constant
    public static <T> None<T> none() {
        return None.none();
    }

    public abstract A valueOrElse(A var1);

    public abstract A valueOrElse(Thunk<? extends A> var1);

    public abstract A valueOrNull();

    public abstract void ifDefined(@NonNull Executable<? super A> var1);

    @Override
    public void forEach(@NonNull Executable<? super A> block) {
        Ensure.isNotNull((String)"var0", block);
        this.ifDefined(block);
    }

    public static <T> Some<T> some(T value) {
        return Some.some(value);
    }

    public static <T> Some<T> someNull() {
        return Some.someNull();
    }

    public static <T> Option<T> nullToNone(T value) {
        if (value == null) {
            return Option.none();
        }
        return Option.some(value);
    }
}

