/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.predicate;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.restrictions.check.NonNull;

public abstract class AbstractPredicate<A>
implements Predicate<A> {
    public abstract boolean eval(@NonNull A var1);

    public Boolean apply(A arg) {
        return this.eval(arg);
    }

    public Predicate<A> not() {
        final class Not
        extends AbstractPredicate<A> {
            final /* synthetic */ AbstractPredicate this$0;

            Not(AbstractPredicate abstractPredicate) {
                this.this$0 = abstractPredicate;
            }

            public boolean eval(A argument) {
                return !this.this$0.eval(argument);
            }

            public AbstractPredicate<A> not() {
                return this.this$0;
            }
        }
        return new Not(this);
    }

    public Predicate<A> or(@NonNull Evaluable<? super A> other) {
        Ensure.isNotNull((String)"var0", other);
        final class Or
        extends AbstractPredicate<A> {
            final /* synthetic */ AbstractPredicate this$0;
            private final /* synthetic */ Evaluable val$other;

            Or(AbstractPredicate abstractPredicate, Evaluable evaluable) {
                this.this$0 = abstractPredicate;
                this.val$other = evaluable;
            }

            public boolean eval(A argument) {
                return this.this$0.eval(argument) || this.val$other.eval(argument);
            }
        }
        return new Or(this, other);
    }

    public Predicate<A> and(@NonNull Evaluable<? super A> other) {
        Ensure.isNotNull((String)"var0", other);
        final class And
        extends AbstractPredicate<A> {
            final /* synthetic */ AbstractPredicate this$0;
            private final /* synthetic */ Evaluable val$other;

            And(AbstractPredicate abstractPredicate, Evaluable evaluable) {
                this.this$0 = abstractPredicate;
                this.val$other = evaluable;
            }

            public boolean eval(A argument) {
                return this.this$0.eval(argument) && this.val$other.eval(argument);
            }
        }
        return new And(this, other);
    }

    public final Predicate<A> andNotNull() {
        return Predicates.notNull().and((Evaluable)this);
    }

    public final Predicate<A> orNull() {
        return Predicates.null_().or((Evaluable)this);
    }

    public <B> Predicate<B> of(final @NonNull Applicable<? super B, ? extends A> other) {
        Ensure.isNotNull((String)"var0", other);
        return new AbstractPredicate<B>(){

            @Override
            public boolean eval(B argument) {
                return AbstractPredicate.this.eval(other.apply(argument));
            }
        };
    }

    public Predicate<A> withEffectOnFalse(final Executable<A> executable) {
        return new AbstractPredicate<A>(){

            @Override
            public boolean eval(A argument) {
                boolean result = AbstractPredicate.this.eval(argument);
                if (result) {
                    executable.exec(argument);
                }
                return result;
            }
        };
    }

    public Predicate<A> withEffectOnTrue(final Executable<A> executable) {
        return new AbstractPredicate<A>(){

            @Override
            public boolean eval(A argument) {
                boolean result = AbstractPredicate.this.eval(argument);
                if (!result) {
                    executable.exec(argument);
                }
                return result;
            }
        };
    }

    public String toString() {
        return "Predicate";
    }
}

