/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.Serializable;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;

public class RDFTriple
implements Serializable {
    private static final long serialVersionUID = 30406L;
    private final RDFResource subject;
    private final RDFResource predicate;
    private final RDFNode object;

    public RDFTriple(RDFResource subject, RDFResource predicate, RDFNode object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public RDFTriple(IRI subject, boolean subjectAnon, IRI predicate, boolean predicateAnon, IRI object, boolean objectAnon) {
        this.subject = new RDFResource(subject, subjectAnon);
        this.predicate = new RDFResource(predicate, predicateAnon);
        this.object = new RDFResource(object, objectAnon);
    }

    public RDFTriple(IRI subject, boolean subjectAnon, IRI predicate, boolean predicateAnon, OWLLiteral object) {
        this.subject = new RDFResource(subject, subjectAnon);
        this.predicate = new RDFResource(predicate, predicateAnon);
        this.object = new RDFLiteral(object);
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public RDFResource getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)o;
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subject.toString());
        sb.append(" ");
        sb.append(this.predicate.toString());
        sb.append(" ");
        sb.append(this.object.toString());
        sb.append(".");
        return sb.toString();
    }
}

