/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public final class EntityType<E extends OWLEntity>
implements Serializable {
    private static final long serialVersionUID = 30406L;
    public static final EntityType<OWLClass> CLASS = new EntityType("Class", "Class", "Classes", OWLRDFVocabulary.OWL_CLASS);
    public static final EntityType<OWLObjectProperty> OBJECT_PROPERTY = new EntityType("ObjectProperty", "Object property", "Object properties", OWLRDFVocabulary.OWL_OBJECT_PROPERTY);
    public static final EntityType<OWLDataProperty> DATA_PROPERTY = new EntityType("DataProperty", "Data property", "Data properties", OWLRDFVocabulary.OWL_DATA_PROPERTY);
    public static final EntityType<OWLAnnotationProperty> ANNOTATION_PROPERTY = new EntityType("AnnotationProperty", "Annotation property", "Annotation properties", OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY);
    public static final EntityType<OWLNamedIndividual> NAMED_INDIVIDUAL = new EntityType("NamedIndividual", "Named individual", "Named individuals", OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL);
    public static final EntityType<OWLDatatype> DATATYPE = new EntityType("Datatype", "Datatype", "Datatypes", OWLRDFVocabulary.RDFS_DATATYPE);
    private static List<EntityType<?>> values = Collections.unmodifiableList(Arrays.asList(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, ANNOTATION_PROPERTY, NAMED_INDIVIDUAL, DATATYPE));
    private final String name;
    private final OWLRDFVocabulary vocabulary;
    private final String printName;
    private final String pluralPrintName;

    private EntityType(String name, String print, String pluralPrint, OWLRDFVocabulary vocabulary) {
        this.name = name;
        this.vocabulary = vocabulary;
        this.printName = print;
        this.pluralPrintName = pluralPrint;
    }

    public OWLRDFVocabulary getVocabulary() {
        return this.vocabulary;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static List<EntityType<?>> values() {
        return values;
    }

    public String getPrintName() {
        return this.printName;
    }

    public String getPluralPrintName() {
        return this.pluralPrintName;
    }
}

