/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.vocab.Namespaces;

public final class OWLOntologyLoaderConfiguration {
    public static final boolean DEFAULT_LOAD_ANNOTATIONS_FLAG_VALUE = true;
    public static final MissingOntologyHeaderStrategy DEFAULT_MISSING_ONTOLOGY_HEADER_STRATEGY = MissingOntologyHeaderStrategy.INCLUDE_GRAPH;
    private boolean loadAnnotations = true;
    private MissingOntologyHeaderStrategy missingOntologyHeaderStrategy = DEFAULT_MISSING_ONTOLOGY_HEADER_STRATEGY;
    private boolean strict = false;
    private boolean reportStackTraces = false;
    private boolean followRedirects = true;
    private MissingImportHandlingStrategy missingImportHandlingStrategy = MissingImportHandlingStrategy.THROW_EXCEPTION;
    private final Set<IRI> ignoredImports = new HashSet<IRI>();

    public OWLOntologyLoaderConfiguration() {
        this.ignoredImports.add(IRI.create(OWLOntologyLoaderConfiguration.stripHash(Namespaces.OWL.toString())));
        this.ignoredImports.add(IRI.create(OWLOntologyLoaderConfiguration.stripHash(Namespaces.RDF.toString())));
        this.ignoredImports.add(IRI.create(OWLOntologyLoaderConfiguration.stripHash(Namespaces.RDFS.toString())));
        this.ignoredImports.add(IRI.create(OWLOntologyLoaderConfiguration.stripHash(Namespaces.SWRL.toString())));
        this.ignoredImports.add(IRI.create(OWLOntologyLoaderConfiguration.stripHash(Namespaces.SWRLB.toString())));
        this.ignoredImports.add(IRI.create(Namespaces.XML.toString()));
        this.ignoredImports.add(IRI.create(Namespaces.XSD.toString()));
    }

    private static String stripHash(String s) {
        if (!s.endsWith("#")) {
            return s;
        }
        return s.substring(0, s.length() - 1);
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return this.missingOntologyHeaderStrategy;
    }

    public OWLOntologyLoaderConfiguration setMissingOntologyHeaderStrategy(MissingOntologyHeaderStrategy missingOntologyHeaderStrategy) {
        if (missingOntologyHeaderStrategy == this.missingOntologyHeaderStrategy) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.missingOntologyHeaderStrategy = missingOntologyHeaderStrategy;
        return copy;
    }

    public OWLOntologyLoaderConfiguration setLoadAnnotationAxioms(boolean b) {
        if (this.loadAnnotations == b) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.loadAnnotations = b;
        return copy;
    }

    public boolean isLoadAnnotationAxioms() {
        return this.loadAnnotations;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public OWLOntologyLoaderConfiguration setFollowRedirects(boolean value) {
        if (value == this.followRedirects) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.followRedirects = value;
        return copy;
    }

    public OWLOntologyLoaderConfiguration setMissingImportHandlingStrategy(MissingImportHandlingStrategy missingImportHandlingStrategy) {
        if (this.missingImportHandlingStrategy == missingImportHandlingStrategy) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.missingImportHandlingStrategy = missingImportHandlingStrategy;
        return copy;
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return this.missingImportHandlingStrategy;
    }

    @Deprecated
    public void setSilentMissingImportsHandling(boolean b) {
        this.missingImportHandlingStrategy = b ? MissingImportHandlingStrategy.SILENT : MissingImportHandlingStrategy.THROW_EXCEPTION;
    }

    @Deprecated
    public boolean isSilentMissingImportsHandling() {
        return this.missingImportHandlingStrategy == MissingImportHandlingStrategy.SILENT;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public OWLOntologyLoaderConfiguration setStrict(boolean strict) {
        if (this.strict == strict) {
            return this;
        }
        OWLOntologyLoaderConfiguration copy = this.copyConfiguration();
        copy.strict = strict;
        return copy;
    }

    public boolean isIgnoredImport(IRI iri) {
        return this.ignoredImports.contains(iri);
    }

    public Set<IRI> getIgnoredImports() {
        return new HashSet<IRI>(this.ignoredImports);
    }

    public OWLOntologyLoaderConfiguration addIgnoredImport(IRI ontologyDocumentIRI) {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.add(ontologyDocumentIRI);
        return configuration;
    }

    public OWLOntologyLoaderConfiguration removeIgnoredImport(IRI ontologyDocumentIRI) {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.remove(ontologyDocumentIRI);
        return configuration;
    }

    public OWLOntologyLoaderConfiguration clearIgnoredImports() {
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.ignoredImports.clear();
        return configuration;
    }

    public OWLOntologyLoaderConfiguration setReportStackTraces(boolean b) {
        if (b == this.reportStackTraces) {
            return this;
        }
        OWLOntologyLoaderConfiguration configuration = this.copyConfiguration();
        configuration.reportStackTraces = b;
        return configuration;
    }

    public boolean isReportStackTrace() {
        return this.reportStackTraces;
    }

    private OWLOntologyLoaderConfiguration copyConfiguration() {
        OWLOntologyLoaderConfiguration copy = new OWLOntologyLoaderConfiguration();
        copy.loadAnnotations = this.loadAnnotations;
        copy.ignoredImports.clear();
        copy.ignoredImports.addAll(this.ignoredImports);
        copy.strict = this.strict;
        copy.missingImportHandlingStrategy = this.missingImportHandlingStrategy;
        copy.missingOntologyHeaderStrategy = this.missingOntologyHeaderStrategy;
        copy.followRedirects = this.followRedirects;
        copy.reportStackTraces = this.reportStackTraces;
        return copy;
    }

    public static enum MissingOntologyHeaderStrategy {
        INCLUDE_GRAPH,
        IMPORT_GRAPH;

    }
}

