/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum OWLFacet {
    LENGTH(Namespaces.XSD, "length", "length"),
    MIN_LENGTH(Namespaces.XSD, "minLength", "minLength"),
    MAX_LENGTH(Namespaces.XSD, "maxLength", "maxLength"),
    PATTERN(Namespaces.XSD, "pattern", "pattern"),
    MIN_INCLUSIVE(Namespaces.XSD, "minInclusive", ">="),
    MIN_EXCLUSIVE(Namespaces.XSD, "minExclusive", ">"),
    MAX_INCLUSIVE(Namespaces.XSD, "maxInclusive", "<="),
    MAX_EXCLUSIVE(Namespaces.XSD, "maxExclusive", "<"),
    TOTAL_DIGITS(Namespaces.XSD, "totalDigits", "totalDigits"),
    FRACTION_DIGITS(Namespaces.XSD, "fractionDigits", "fractionDigits"),
    LANG_RANGE(Namespaces.RDF, "langRange", "langRange");

    public static final Set<IRI> FACET_IRIS;
    private final IRI iri;
    private final String shortName;
    private final String symbolicForm;

    private OWLFacet(Namespaces ns, String shortName, String symbolicForm) {
        this.iri = IRI.create(ns.toString(), shortName);
        this.shortName = shortName;
        this.symbolicForm = symbolicForm;
    }

    public String getShortName() {
        return this.shortName;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public String getSymbolicForm() {
        return this.symbolicForm;
    }

    public String toString() {
        return this.shortName;
    }

    public static Set<IRI> getFacetIRIs() {
        return FACET_IRIS;
    }

    public static OWLFacet getFacet(IRI iri) {
        for (OWLFacet vocabulary : OWLFacet.values()) {
            if (!vocabulary.getIRI().equals(iri)) continue;
            return vocabulary;
        }
        return null;
    }

    public static OWLFacet getFacetByShortName(String shortName) {
        for (OWLFacet vocabulary : OWLFacet.values()) {
            if (!vocabulary.getShortName().equals(shortName)) continue;
            return vocabulary;
        }
        return null;
    }

    public static OWLFacet getFacetBySymbolicName(String symbolicName) {
        for (OWLFacet vocabulary : OWLFacet.values()) {
            if (!vocabulary.getSymbolicForm().equals(symbolicName)) continue;
            return vocabulary;
        }
        return null;
    }

    public static Set<String> getFacets() {
        HashSet<String> result = new HashSet<String>();
        for (OWLFacet v : OWLFacet.values()) {
            result.add(v.getSymbolicForm());
        }
        return result;
    }

    static {
        HashSet<IRI> iris = new HashSet<IRI>();
        for (OWLFacet v : OWLFacet.values()) {
            iris.add(v.getIRI());
        }
        FACET_IRIS = Collections.unmodifiableSet(iris);
    }
}

