/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImpl
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    private static final int COMPRESSION_LIMIT = 160;
    private final LiteralWrapper literal;
    private final OWLDatatype datatype;
    private final String lang;
    private final int hashcode;

    public OWLLiteralImpl(String literal, String lang, OWLDatatype datatype) {
        this.literal = new LiteralWrapper(literal);
        if (lang == null || lang.length() == 0) {
            this.lang = "";
            this.datatype = datatype;
        } else {
            if (datatype != null && !datatype.isRDFPlainLiteral()) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.lang = lang;
            this.datatype = new OWLDatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
        }
        this.hashcode = this.getHashCode();
    }

    @Override
    public String getLiteral() {
        return this.literal.get();
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.datatype.getIRI().equals(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    }

    @Override
    public boolean isInteger() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_INTEGER.getIRI());
    }

    @Override
    public boolean isBoolean() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    @Override
    public boolean isDouble() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    @Override
    public boolean isFloat() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_FLOAT.getIRI());
    }

    @Override
    public boolean hasLang() {
        return !this.lang.equals("");
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.literal.get());
    }

    @Override
    public boolean parseBoolean() throws NumberFormatException {
        if (this.literal.get().equals("0")) {
            return false;
        }
        if (this.literal.get().equals("1")) {
            return true;
        }
        if (this.literal.get().equals("true")) {
            return true;
        }
        if (this.literal.get().equals("false")) {
            return false;
        }
        return false;
    }

    @Override
    public double parseDouble() throws NumberFormatException {
        return Double.parseDouble(this.literal.get());
    }

    @Override
    public float parseFloat() throws NumberFormatException {
        return Float.parseFloat(this.literal.get());
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang(String l) {
        if (l == null && this.lang == null) {
            return true;
        }
        if (l == null) {
            l = "";
        }
        return this.lang != null && this.lang.equalsIgnoreCase(l.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode *= 37;
        hashCode = this.literal.l != null ? (hashCode += this.literal.l.hashCode()) : (hashCode += Arrays.hashCode(this.literal.bytes));
        if (this.hasLang()) {
            hashCode = hashCode * 37 + this.getLang().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            return this.literal.get().equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.lang.equals(other.getLang());
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.literal.get().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    private static final class LiteralWrapper
    implements Serializable {
        private static final long serialVersionUID = 30406L;
        String l;
        byte[] bytes;
        private static final String COMPRESSED_ENCODING = "UTF-16";

        LiteralWrapper(String s) {
            if (s.length() > 160) {
                try {
                    this.bytes = this.compress(s);
                    this.l = null;
                }
                catch (IOException e) {
                    this.l = s;
                    this.bytes = null;
                }
            } else {
                this.bytes = null;
                this.l = s;
            }
        }

        String get() {
            if (this.l != null) {
                return this.l;
            }
            try {
                return this.decompress(this.bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        byte[] compress(String s) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream zipout = new GZIPOutputStream(out);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipout, COMPRESSED_ENCODING);
            writer.write(s);
            ((Writer)writer).flush();
            zipout.finish();
            zipout.flush();
            return out.toByteArray();
        }

        String decompress(byte[] result) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(result);
            GZIPInputStream zipin = new GZIPInputStream(in);
            InputStreamReader reader = new InputStreamReader((InputStream)zipin, COMPRESSED_ENCODING);
            StringBuilder b = new StringBuilder();
            int c = ((Reader)reader).read();
            while (c > -1) {
                b.append((char)c);
                c = ((Reader)reader).read();
            }
            return b.toString();
        }
    }
}

