/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import net.sourceforge.plantuml.Log;

public class FileSystem {
    private static final FileSystem singleton = new FileSystem();
    private final ThreadLocal<File> currentDir = new ThreadLocal();

    private FileSystem() {
        this.reset();
    }

    public static FileSystem getInstance() {
        return singleton;
    }

    public void setCurrentDir(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        Log.info("Setting current dir: " + file);
        this.currentDir.set(file);
    }

    public File getCurrentDir() {
        return this.currentDir.get();
    }

    public File getFile(String string) throws IOException {
        File file = this.currentDir.get();
        if (file == null) {
            return new File(string).getCanonicalFile();
        }
        return new File(file.getAbsoluteFile(), string).getCanonicalFile();
    }

    public void reset() {
        this.setCurrentDir(new File("."));
    }
}

