/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemError
extends AbstractPSystem {
    private final List<String> htmlStrings = new ArrayList<String>();
    private final List<String> plainStrings = new ArrayList<String>();
    private final int higherErrorPosition;
    private final List<ErrorUml> printedErrors;

    public PSystemError(UmlSource umlSource, List<ErrorUml> list) {
        this.setSource(umlSource);
        int n = this.getHigherErrorPosition(ErrorUmlType.EXECUTION_ERROR, list);
        int n2 = this.getHigherErrorPosition(ErrorUmlType.SYNTAX_ERROR, list);
        if (n == Integer.MIN_VALUE && n2 == Integer.MIN_VALUE) {
            throw new IllegalStateException();
        }
        if (n >= n2) {
            this.higherErrorPosition = n;
            this.printedErrors = this.getErrorsAt(n, ErrorUmlType.EXECUTION_ERROR, list);
        } else {
            assert (n2 > n);
            this.higherErrorPosition = n2;
            this.printedErrors = this.getErrorsAt(n2, ErrorUmlType.SYNTAX_ERROR, list);
        }
        this.appendSource(this.higherErrorPosition);
    }

    public PSystemError(UmlSource umlSource, ErrorUml errorUml) {
        this(umlSource, Collections.singletonList(errorUml));
    }

    @Override
    public void exportDiagram(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption) throws IOException {
        this.getPngError().writeImage(outputStream, this.getMetadata(), fileFormatOption);
    }

    public GraphicStrings getPngError() throws IOException {
        return new GraphicStrings(this.htmlStrings);
    }

    private void appendSource(int n) {
        int n2;
        int n3 = n - 4 + 1;
        if (n3 <= 0) {
            n2 = 0;
        } else {
            if (n3 == 1) {
                this.htmlStrings.add("... (skipping 1 line) ...");
                this.plainStrings.add("... (skipping 1 line) ...");
            } else {
                this.htmlStrings.add("... (skipping " + n3 + " lines) ...");
                this.plainStrings.add("... (skipping " + n3 + " lines) ...");
            }
            n2 = n - 4 + 1;
        }
        for (int i = n2; i < n; ++i) {
            this.htmlStrings.add(StringUtils.hideComparatorCharacters(this.getSource().getLine(i)));
            this.plainStrings.add(this.getSource().getLine(i));
        }
        String string = this.getSource().getLine(n);
        this.htmlStrings.add("<w:red>" + StringUtils.hideComparatorCharacters(string) + "</w>");
        this.plainStrings.add(StringUtils.hideComparatorCharacters(string));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append("^");
        }
        this.plainStrings.add(stringBuilder.toString());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ErrorUml iterator : this.printedErrors) {
            linkedHashSet.add(iterator.getError());
        }
        for (String string2 : linkedHashSet) {
            this.htmlStrings.add(" <color:red>" + string2);
            this.plainStrings.add(" " + string2);
        }
        boolean bl = true;
        for (String string3 : this.getSuggest()) {
            if (bl) {
                this.htmlStrings.add(" <color:white><i>" + string3);
            } else {
                this.htmlStrings.add("<color:white>" + StringUtils.hideComparatorCharacters(string3));
            }
            bl = false;
        }
    }

    public List<String> getSuggest() {
        boolean bl = false;
        for (ErrorUml object : this.printedErrors) {
            if (!object.hasSuggest()) continue;
            bl = true;
        }
        if (!bl) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add("Did you mean:");
        for (ErrorUml errorUml : this.printedErrors) {
            if (!errorUml.hasSuggest()) continue;
            arrayList.add(errorUml.getSuggest().getSuggestedLine());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<ErrorUml> getErrors(ErrorUmlType errorUmlType, List<ErrorUml> list) {
        LinkedHashSet<ErrorUml> linkedHashSet = new LinkedHashSet<ErrorUml>();
        for (ErrorUml errorUml : list) {
            if (errorUml.getType() != errorUmlType) continue;
            linkedHashSet.add(errorUml);
        }
        return linkedHashSet;
    }

    private int getHigherErrorPosition(ErrorUmlType errorUmlType, List<ErrorUml> list) {
        int n = Integer.MIN_VALUE;
        for (ErrorUml errorUml : this.getErrors(errorUmlType, list)) {
            if (errorUml.getPosition() <= n) continue;
            n = errorUml.getPosition();
        }
        return n;
    }

    private List<ErrorUml> getErrorsAt(int n, ErrorUmlType errorUmlType, List<ErrorUml> list) {
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        for (ErrorUml errorUml : this.getErrors(errorUmlType, list)) {
            if (errorUml.getPosition() != n || !StringUtils.isNotEmpty(errorUml.getError())) continue;
            arrayList.add(errorUml);
        }
        return arrayList;
    }

    @Override
    public String getDescription() {
        return "(Error)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            for (String string : this.plainStrings) {
                printStream.println(StringUtils.showComparatorCharacters(string));
            }
        }
    }

    public final int getHigherErrorPosition() {
        return this.higherErrorPosition;
    }

    public final Collection<ErrorUml> getErrorsUml() {
        return Collections.unmodifiableCollection(this.printedErrors);
    }

    @Override
    public String getWarningOrError() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDescription());
        stringBuilder.append('\n');
        for (CharSequence charSequence : this.getTitle()) {
            stringBuilder.append(charSequence);
            stringBuilder.append('\n');
        }
        stringBuilder.append('\n');
        for (String string : this.getSuggest()) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

