/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.activitydiagram.ConditionalContext;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagram
extends CucaDiagram {
    private IEntity lastEntityConsulted;
    private IEntity lastEntityBrancheConsulted;
    private ConditionalContext currentContext;

    private String getAutoBranch() {
        return "#" + UniqueSequence.getValue();
    }

    public IEntity getOrCreate(String string, String string2, EntityType entityType) {
        IEntity iEntity;
        if (this.entityExist(string)) {
            iEntity = super.getOrCreateEntity(string, entityType);
            if (iEntity.getEntityType() != entityType) {
                return null;
            }
        } else {
            iEntity = this.createEntity(string, string2, entityType);
        }
        this.updateLasts(iEntity);
        return iEntity;
    }

    public void startIf(String string) {
        IEntity iEntity = this.createEntity(string == null ? this.getAutoBranch() : string, "", EntityType.BRANCH);
        this.currentContext = new ConditionalContext(this.currentContext, iEntity, Direction.DOWN);
    }

    public void endif() {
        this.currentContext = this.currentContext.getParent();
    }

    public IEntity getStart() {
        return this.getOrCreate("start", "start", EntityType.CIRCLE_START);
    }

    public IEntity getEnd() {
        return this.getOrCreate("end", "end", EntityType.CIRCLE_END);
    }

    private void updateLasts(IEntity iEntity) {
        if (iEntity.getEntityType() == EntityType.NOTE) {
            return;
        }
        this.lastEntityConsulted = iEntity;
        if (iEntity.getEntityType() == EntityType.BRANCH) {
            this.lastEntityBrancheConsulted = iEntity;
        }
    }

    @Override
    public IEntity createEntity(String string, String string2, EntityType entityType) {
        IEntity iEntity = super.createEntity(string, string2, entityType);
        this.updateLasts(iEntity);
        return iEntity;
    }

    public IEntity createNote(String string, String string2) {
        return super.createEntity(string, string2, EntityType.NOTE);
    }

    @Override
    protected final List<String> getDotStrings() {
        return Arrays.asList("nodesep=.20;", "ranksep=0.4;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11];");
    }

    @Override
    public String getDescription() {
        return "(" + this.getEntities().size() + " activities)";
    }

    public IEntity getLastEntityConsulted() {
        return this.lastEntityConsulted;
    }

    @Deprecated
    public IEntity getLastEntityBrancheConsulted() {
        return this.lastEntityBrancheConsulted;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    public final ConditionalContext getCurrentContext() {
        return this.currentContext;
    }

    public final void setLastEntityConsulted(IEntity iEntity) {
        this.lastEntityConsulted = iEntity;
    }

    public IEntity createInnerActivity() {
        String string = "##" + UniqueSequence.getValue();
        IEntityMutable iEntityMutable = this.getOrCreateGroup(string, string, null, GroupType.INNER_ACTIVITY, this.getCurrentGroup());
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
        return iEntityMutable;
    }

    public void concurrentActivity(String string) {
        if (this.getCurrentGroup().zgetGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            this.endGroup();
        }
        String string2 = "##" + UniqueSequence.getValue();
        if (this.getCurrentGroup().zgetGroupType() != GroupType.INNER_ACTIVITY) {
            throw new IllegalStateException("type=" + (Object)((Object)this.getCurrentGroup().zgetGroupType()));
        }
        IEntityMutable iEntityMutable = this.getOrCreateGroup(string2, "code", null, GroupType.CONCURRENT_ACTIVITY, this.getCurrentGroup());
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
    }
}

