/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkLongActivity
extends CommandMultilines2<ActivityDiagram> {
    public CommandLinkLongActivity(ActivityDiagram activityDiagram) {
        super(activityDiagram, CommandLinkLongActivity.getRegexConcat());
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*([^\"]*)\"(?:\\s+as\\s+([\\p{L}0-9][\\p{L}0-9_.]*))?\\s*(\\<\\<.*\\>\\>)?\\s*(?:in\\s+(\"[^\"]+\"|\\S+))?\\s*(#\\w+)?$";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("FIRST", true, new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9][\\p{L}0-9_.]*)"), new RegexLeaf("BAR", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?")), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR", "(#\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("ARROW", "([-=.]+(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?[-=.]*\\>)"), new RegexLeaf("\\s*"), new RegexLeaf("BRACKET", "(?:\\[([^\\]*]+[^\\]]*)\\])?"), new RegexLeaf("\\s*"), new RegexLeaf("DESC", "\"([^\"]*?)"), new RegexLeaf("\\s*"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        StringUtils.trim(list, false);
        Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
        IEntity iEntity = CommandLinkActivity.getEntity((ActivityDiagram)this.getSystem(), map, true);
        if (map.get("STEREOTYPE").get(0) != null) {
            iEntity.setStereotype(new Stereotype(map.get("STEREOTYPE").get(0)));
        }
        if (map.get("BACKCOLOR").get(0) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("BACKCOLOR").get(0)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = map.get("DESC").get(0);
        Url url = null;
        if (StringUtils.isNotEmpty(string) && (url = StringUtils.extractUrl(string)) == null) {
            stringBuilder.append(string);
            stringBuilder.append("\\n");
        }
        for (int i = 1; i < list.size() - 1; ++i) {
            if (i == 1 && url == null && (url = StringUtils.extractUrl(list.get(i))) != null) continue;
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 2) continue;
            stringBuilder.append("\\n");
        }
        List<String> list2 = StringUtils.getSplit(Pattern.compile(this.getPatternEnd()), list.get(list.size() - 1));
        if (StringUtils.isNotEmpty(list2.get(0))) {
            if (stringBuilder.length() > 0 && !stringBuilder.toString().endsWith("\\n")) {
                stringBuilder.append("\\n");
            }
            stringBuilder.append(list2.get(0));
        }
        String string2 = stringBuilder.toString();
        String string3 = list2.get(1) == null ? string2 : list2.get(1);
        String string4 = null;
        if (list2.get(3) != null) {
            string4 = list2.get(3);
            string4 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string4);
        }
        if (string4 != null) {
            ((ActivityDiagram)this.getSystem()).getOrCreateGroup(string4, string4, null, GroupType.PACKAGE, null);
        }
        IEntity iEntity2 = ((ActivityDiagram)this.getSystem()).createEntity(string3, string2, EntityType.ACTIVITY);
        if (string4 != null) {
            ((ActivityDiagram)this.getSystem()).endGroup();
        }
        if (url != null) {
            iEntity2.addUrl(url);
        }
        if (list2.get(2) != null) {
            iEntity2.setStereotype(new Stereotype(list2.get(2)));
        }
        if (list2.get(4) != null) {
            iEntity2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(list2.get(4)));
        }
        if (iEntity == null || iEntity2 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        String string5 = StringUtils.manageArrowForCuca(map.get("ARROW").get(0));
        int n = string5.length() - 1;
        String string6 = map.get("BRACKET").get(0);
        LinkType linkType = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if (map.get("ARROW").get(0).contains(".")) {
            linkType = linkType.getDotted();
        }
        Link link = new Link(iEntity, iEntity2, linkType, string6, n);
        Direction direction = StringUtils.getArrowDirection(map.get("ARROW").get(0));
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((ActivityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

