/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkClass3
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkClass3(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram) {
        super(abstractClassOrObjectDiagram, CommandLinkClass3.getRegexConcat(abstractClassOrObjectDiagram.getUmlDiagramType()));
    }

    static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)\\s+)?"), new RegexOr(new RegexLeaf("ENT1", "(?:" + CommandLinkClass3.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("COUPLE1", "\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)")), new RegexLeaf("\\s*"), new RegexLeaf("FIRST_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexLeaf("ARROW", "(( +o|[\\[<*+^]|[<\\[]\\|)?([-=.]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?([-=.]*)(o +|[\\]>*+^]|\\|[>\\]])?)"), new RegexLeaf("\\s*"), new RegexLeaf("SECOND_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("ENT2", "(?:" + CommandLinkClass3.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("COUPLE2", "\\(\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*,\\s*(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s*\\)")), new RegexLeaf("\\s*"), new RegexLeaf("LABEL_LINK", "(?::\\s*(.+))?"), new RegexLeaf("$"));
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|abstract\\s+class|abstract|class)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        Object object;
        Object object2;
        Object object3;
        String string = map.get("ENT1").get(1);
        String string2 = map.get("ENT2").get(1);
        if (string == null) {
            return this.executeArgSpecial1(map);
        }
        if (string2 == null) {
            return this.executeArgSpecial2(map);
        }
        string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string) && ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string2)) {
            return this.executePackageLink(map);
        }
        if (((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string) || ((AbstractClassOrObjectDiagram)this.getSystem()).isGroup(string2)) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string);
        IEntity iEntity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string2);
        if (map.get("ENT1").get(0) != null && (object3 = EntityType.getEntityType(map.get("ENT1").get(0))) != EntityType.OBJECT) {
            iEntity.muteToType((EntityType)((Object)object3));
        }
        if (map.get("ENT2").get(0) != null && (object3 = EntityType.getEntityType(map.get("ENT2").get(0))) != EntityType.OBJECT) {
            iEntity2.muteToType((EntityType)((Object)object3));
        }
        if (map.get("ENT1").get(2) != null) {
            iEntity.setStereotype(new Stereotype(map.get("ENT1").get(2), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if (map.get("ENT2").get(2) != null) {
            iEntity2.setStereotype(new Stereotype(map.get("ENT2").get(2), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((AbstractClassOrObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        object3 = this.getLinkType(map);
        Direction direction = this.getDirection(map);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(map);
        String string3 = map.get("FIRST_LABEL").get(0);
        String string4 = map.get("SECOND_LABEL").get(0);
        String string5 = null;
        if (map.get("LABEL_LINK").get(0) != null) {
            string5 = map.get("LABEL_LINK").get(0);
            if (string3 == null && string4 == null) {
                object2 = Pattern.compile("^\"([^\"]+)\"([^\"]+)\"([^\"]+)\"$");
                object = ((Pattern)object2).matcher(string5);
                if (((Matcher)object).matches()) {
                    string3 = ((Matcher)object).group(1);
                    string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(((Matcher)object).group(2).trim()).trim();
                    string4 = ((Matcher)object).group(3);
                } else {
                    Pattern pattern = Pattern.compile("^\"([^\"]+)\"([^\"]+)$");
                    Matcher matcher = pattern.matcher(string5);
                    if (matcher.matches()) {
                        string3 = matcher.group(1);
                        string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(2).trim()).trim();
                        string4 = null;
                    } else {
                        Pattern pattern2 = Pattern.compile("^([^\"]+)\"([^\"]+)\"$");
                        Matcher matcher2 = pattern2.matcher(string5);
                        if (matcher2.matches()) {
                            string3 = null;
                            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher2.group(1).trim()).trim();
                            string4 = matcher2.group(2);
                        }
                    }
                }
            }
            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        }
        object2 = LinkArrow.NONE;
        if ("<".equals(string5)) {
            object2 = LinkArrow.BACKWARD;
            string5 = null;
        } else if (">".equals(string5)) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string5 = null;
        } else if (string5 != null && string5.startsWith("< ")) {
            object2 = LinkArrow.BACKWARD;
            string5 = string5.substring(2).trim();
        } else if (string5 != null && string5.startsWith("> ")) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string5 = string5.substring(2).trim();
        } else if (string5 != null && string5.endsWith(" >")) {
            object2 = LinkArrow.DIRECT_NORMAL;
            string5 = string5.substring(0, string5.length() - 2).trim();
        } else if (string5 != null && string5.endsWith(" <")) {
            object2 = LinkArrow.BACKWARD;
            string5 = string5.substring(0, string5.length() - 2).trim();
        }
        object = new Link(iEntity, iEntity2, (LinkType)object3, string5, n, string3, string4, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            object = ((Link)object).getInv();
        }
        ((Link)object).setLinkArrow((LinkArrow)((Object)object2));
        this.addLink((Link)object, map.get("HEADER").get(0));
        return CommandExecutionResult.ok();
    }

    private void addLink(Link link, String string) {
        ((AbstractClassOrObjectDiagram)this.getSystem()).addLink(link);
        if (string == null) {
            LinkType linkType = link.getType();
        } else {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private CommandExecutionResult executePackageLink(Map<String, RegexPartialMatch> map) {
        String string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT1").get(1));
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT2").get(1));
        IEntityMutable iEntityMutable = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(string);
        IEntityMutable iEntityMutable2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getGroup(string2);
        LinkType linkType = this.getLinkType(map);
        Direction direction = this.getDirection(map);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(map);
        String string3 = map.get("LABEL_LINK").get(0);
        String string4 = map.get("FIRST_LABEL").get(0);
        String string5 = map.get("SECOND_LABEL").get(0);
        Link link = new Link(iEntityMutable, iEntityMutable2, linkType, string3, n, string4, string5, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink(link, map.get("HEADER").get(0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(Map<String, RegexPartialMatch> map) {
        String string = map.get("COUPLE1").get(0);
        String string2 = map.get("COUPLE1").get(1);
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No class " + string);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string2)) {
            return CommandExecutionResult.error("No class " + string2);
        }
        String string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT2").get(1));
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string3);
        LinkType linkType = this.getLinkType(map);
        String string4 = map.get("LABEL_LINK").get(0);
        int n = this.getQueueLength(map);
        String string5 = map.get("HEADER").get(0);
        boolean bl = ((AbstractClassOrObjectDiagram)this.getSystem()).associationClass(1, string, string2, iEntity, linkType, string4);
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(Map<String, RegexPartialMatch> map) {
        String string = map.get("COUPLE2").get(0);
        String string2 = map.get("COUPLE2").get(1);
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No class " + string);
        }
        if (!((AbstractClassOrObjectDiagram)this.getSystem()).entityExist(string2)) {
            return CommandExecutionResult.error("No class " + string2);
        }
        String string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("ENT1").get(1));
        IEntity iEntity = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateClass(string3);
        LinkType linkType = this.getLinkType(map);
        String string4 = map.get("LABEL_LINK").get(0);
        int n = this.getQueueLength(map);
        String string5 = map.get("HEADER").get(0);
        boolean bl = ((AbstractClassOrObjectDiagram)this.getSystem()).associationClass(2, string, string2, iEntity, linkType, string4);
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(string = string.trim())) {
            return LinkDecor.EXTENDS;
        }
        if ("<".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(string = string.trim())) {
            return LinkDecor.EXTENDS;
        }
        if (">".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(Map<String, RegexPartialMatch> map) {
        RegexPartialMatch regexPartialMatch = map.get("ARROW");
        LinkDecor linkDecor = this.getDecors1(regexPartialMatch.get(1));
        LinkDecor linkDecor2 = this.getDecors2(regexPartialMatch.get(5));
        LinkType linkType = new LinkType(linkDecor2, linkDecor);
        if (regexPartialMatch.get(0).contains(".")) {
            linkType = linkType.getDashed();
        }
        return linkType;
    }

    private int getQueueLength(Map<String, RegexPartialMatch> map) {
        String string = map.get("ARROW").get(0);
        string = string.replaceAll("[^-.=]", "");
        return string.length();
    }

    private Direction getDirection(Map<String, RegexPartialMatch> map) {
        RegexPartialMatch regexPartialMatch = map.get("ARROW");
        LinkDecor linkDecor = this.getDecors1(regexPartialMatch.get(1));
        LinkDecor linkDecor2 = this.getDecors2(regexPartialMatch.get(5));
        String string = map.get("ARROW").get(0);
        if ((string = string.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            string = string.substring(1);
        }
        if (string.endsWith("o")) {
            string = string.substring(0, string.length() - 1);
        }
        Direction direction = StringUtils.getQueueDirection(string);
        if (this.isInversed(linkDecor, linkDecor2) && string.matches(".*\\w.*")) {
            direction = direction.getInv();
        }
        return direction;
    }

    private boolean isInversed(LinkDecor linkDecor, LinkDecor linkDecor2) {
        if (linkDecor == LinkDecor.ARROW && linkDecor2 != LinkDecor.ARROW) {
            return true;
        }
        if (linkDecor2 == LinkDecor.AGREGATION) {
            return true;
        }
        if (linkDecor2 == LinkDecor.COMPOSITION) {
            return true;
        }
        if (linkDecor2 == LinkDecor.PLUS) {
            return true;
        }
        return linkDecor2 == LinkDecor.EXTENDS;
    }
}

