/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMouseOver
extends CommandMultilines2<ClassDiagram> {
    public CommandMouseOver(ClassDiagram classDiagram) {
        super(classDiagram, CommandMouseOver.getRegexConcat());
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*\\}\\s*$";
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("mouseover\\s+"), new RegexOr(new RegexLeaf("NAME1", "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)"), new RegexLeaf("NAME3", "\"([^\"]+)\"")), new RegexLeaf("\\s*\\{\\s*$"));
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        StringUtils.trim(list, false);
        Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
        String string = map.get("NAME1").get(0);
        if (string == null) {
            string = map.get("NAME3").get(0);
        }
        if (!((ClassDiagram)this.getSystem()).entityExist(string)) {
            return CommandExecutionResult.error("No such entity");
        }
        IEntity iEntity = ((ClassDiagram)this.getSystem()).getEntities().get(string);
        for (String string2 : list.subList(1, list.size() - 1)) {
            iEntity.mouseOver(string2);
        }
        return CommandExecutionResult.ok();
    }
}

