/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilinesBracket<S extends PSystem>
implements Command {
    private final S system;
    private final Pattern starting;

    public CommandMultilinesBracket(S s, String string) {
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.system = s;
        this.starting = Pattern.compile(string);
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"BRACKET: " + this.starting.pattern()};
    }

    protected void actionIfCommandValid() {
    }

    protected S getSystem() {
        return this.system;
    }

    protected final Pattern getStartingPattern() {
        return this.starting;
    }

    @Override
    public boolean isDeprecated(List<String> list) {
        return false;
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return null;
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher matcher = this.starting.matcher(list.get(0).trim());
        if (!matcher.matches()) {
            return CommandControl.NOT_OK;
        }
        if (list.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        int n = 1;
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).trim();
            if (!this.isLineConsistent(string, n)) {
                return CommandControl.NOT_OK;
            }
            if (string.endsWith("{")) {
                ++n;
            }
            if (string.endsWith("}")) {
                --n;
            }
            if (n >= 0) continue;
            return CommandControl.NOT_OK;
        }
        if (n != 0) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected abstract boolean isLineConsistent(String var1, int var2);
}

