/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPackage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackage(AbstractEntityDiagram abstractEntityDiagram) {
        super(abstractEntityDiagram, CommandPackage.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^package\\s+"), new RegexLeaf("NAME", "(\"[^\"]+\"|[^#\\s{}]*)"), new RegexLeaf("AS", "(?:\\s+as\\s+([\\p{L}0-9_.]+))?"), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#[0-9a-fA-F]{6}|#?\\w+)?"), new RegexLeaf("\\s*\\{?$"));
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        String string;
        String string2;
        String string3;
        String string4 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("NAME").get(0));
        if (map.get("AS").get(0) == null) {
            if (string4.length() == 0) {
                string3 = "##" + UniqueSequence.getValue();
                string2 = null;
            } else {
                string2 = string3 = string4;
            }
        } else {
            string2 = string4;
            string3 = map.get("AS").get(0);
        }
        IEntityMutable iEntityMutable = ((AbstractEntityDiagram)this.getSystem()).getCurrentGroup();
        IEntityMutable iEntityMutable2 = ((AbstractEntityDiagram)this.getSystem()).getOrCreateGroup(string3, string2, null, GroupType.PACKAGE, iEntityMutable);
        String string5 = map.get("STEREOTYPE").get(0);
        if (string5 != null) {
            iEntityMutable2.zsetStereotype(new Stereotype(string5));
        }
        if ((string = map.get("COLOR").get(0)) != null) {
            iEntityMutable2.zsetBackColor(HtmlColorUtils.getColorIfValid(string));
        }
        return CommandExecutionResult.ok();
    }
}

