/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteOnLinkCommand
implements SingleMultiFactoryCommand<CucaDiagram> {
    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?\\s*on\\s+link"), new RegexLeaf("COLOR", "\\s*(#\\w+)?\\s*:\\s*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?\\s*on\\s+link"), new RegexLeaf("COLOR", "\\s*(#\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    public Command createMultiLine(CucaDiagram cucaDiagram) {
        return new CommandMultilines2<CucaDiagram>(cucaDiagram, this.getRegexConcatMultiLine()){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?note$";
            }

            @Override
            public CommandExecutionResult execute(List<String> list) {
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                if (list2.size() > 0) {
                    List<CharSequence> list3 = StringUtils.manageEmbededDiagrams(list2);
                    Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0));
                    return FactoryNoteOnLinkCommand.this.executeInternal((CucaDiagram)this.getSystem(), list3, map);
                }
                return CommandExecutionResult.error("No note defined");
            }
        };
    }

    @Override
    public Command createSingleLine(CucaDiagram cucaDiagram) {
        return new SingleLineCommand2<CucaDiagram>(cucaDiagram, this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
                List<String> list = StringUtils.getWithNewlines(map.get("NOTE").get(0));
                return FactoryNoteOnLinkCommand.this.executeInternal((CucaDiagram)this.getSystem(), list, map);
            }
        };
    }

    private CommandExecutionResult executeInternal(CucaDiagram cucaDiagram, List<? extends CharSequence> list, Map<String, RegexPartialMatch> map) {
        Link link = cucaDiagram.getLastLink();
        if (link == null) {
            return CommandExecutionResult.error("No link defined");
        }
        Position position = Position.BOTTOM;
        if (map.get("POSITION").get(0) != null) {
            position = Position.valueOf(map.get("POSITION").get(0).toUpperCase());
        }
        Url url = null;
        if (list.size() > 0) {
            url = StringUtils.extractUrl(((Object)list.get(0)).toString());
        }
        if (url != null) {
            list = list.subList(1, list.size());
        }
        link.addNote(list, position, HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        return CommandExecutionResult.ok();
    }
}

