/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.componentdiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.componentdiagram.ComponentDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateComponent2
extends SingleLineCommand2<ComponentDiagram> {
    public CommandCreateComponent2(ComponentDiagram componentDiagram) {
        super(componentDiagram, CommandCreateComponent2.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("(?:component\\s+)?"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+|\\[[^\\]*]+[^\\]]*\\]|\"[^\"]+\")\\s*"), new RegexLeaf("AS", "(?:as\\s+\\[?([\\p{L}0-9_.]+)\\]?)?"), new RegexLeaf("STEREOTYPE", "(?:\\s*([\\<\\[]{2}.*[\\>\\]]{2}))?"), new RegexLeaf("COLOR", "\\s*(#\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    protected boolean isForbidden(String string) {
        return string.matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        String string;
        String string2;
        EntityType entityType = EntityType.COMPONENT;
        if (map.get("AS").get(0) == null) {
            string = string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("CODE").get(0));
        } else {
            string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("CODE").get(0));
            string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(map.get("AS").get(0));
        }
        String string3 = map.get("STEREOTYPE").get(0);
        IEntity iEntity = ((ComponentDiagram)this.getSystem()).getOrCreateEntity(string2, entityType);
        iEntity.setDisplay2(string);
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3, ((ComponentDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ComponentDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("COLOR").get(0)));
        return CommandExecutionResult.ok();
    }
}

