/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.componentdiagram.command;

import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.componentdiagram.ComponentDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkComponent
extends SingleLineCommand2<ComponentDiagram> {
    public CommandLinkComponent(ComponentDiagram componentDiagram) {
        super(componentDiagram, CommandLinkComponent.getRegex());
    }

    static RegexConcat getRegex() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkComponent.getRegexGroup("G1"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("AR_TO_RIGHT", "(([-=.]+)(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?([-=.]*)([\\]>^]|\\|[>\\]])?)"), new RegexLeaf("AR_TO_LEFT", "(([\\[<^]|[<\\[]\\|)?([-=.]*)(left|right|up|down|le?|ri?|up?|do?)?([-=.]+))")), new RegexLeaf("\\s*"), CommandLinkComponent.getRegexGroup("G2"), new RegexLeaf("\\s*"), new RegexLeaf("END", "(?::\\s*([^\"]+))?$"));
    }

    private static RegexLeaf getRegexGroup(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|:[^:]+:|\\[[^\\]*]+[^\\]]*\\]|\\(\\)\\s*[\\p{L}0-9_.]+|\\(\\)\\s*\"[^\"]+\")(?:\\s*(\\<\\<.*\\>\\>))?");
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        LinkType linkType;
        String string;
        String string2 = map.get("G1").get(0);
        String string3 = map.get("G2").get(0);
        if (((ComponentDiagram)this.getSystem()).isGroup(string2) && ((ComponentDiagram)this.getSystem()).isGroup(string3)) {
            return this.executePackageLink(map);
        }
        if (((ComponentDiagram)this.getSystem()).isGroup(string2) || ((ComponentDiagram)this.getSystem()).isGroup(string3)) {
            return CommandExecutionResult.error("Package can be only linked to other package");
        }
        IEntity iEntity = ((ComponentDiagram)this.getSystem()).getOrCreateClass(string2);
        IEntity iEntity2 = ((ComponentDiagram)this.getSystem()).getOrCreateClass(string3);
        if (map.get("G1").get(1) != null) {
            iEntity.setStereotype(new Stereotype(map.get("G1").get(1)));
        }
        if (map.get("G2").get(1) != null) {
            iEntity2.setStereotype(new Stereotype(map.get("G2").get(1)));
        }
        if (map.get("AR_TO_RIGHT").get(0) != null) {
            string = map.get("AR_TO_RIGHT").get(1) + map.get("AR_TO_RIGHT").get(3);
            linkType = this.getLinkTypeNormal(string, map.get("AR_TO_RIGHT").get(4));
        } else {
            string = map.get("AR_TO_LEFT").get(2) + map.get("AR_TO_LEFT").get(4);
            linkType = this.getLinkTypeNormal(string, map.get("AR_TO_LEFT").get(1)).getInversed();
        }
        Direction direction = this.getDirection(map);
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string = "-";
        }
        Link link = new Link(iEntity, iEntity2, linkType, map.get("END").get(0), string.length());
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((ComponentDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private Direction getDirection(Map<String, RegexPartialMatch> map) {
        if (map.get("AR_TO_RIGHT").get(2) != null) {
            return StringUtils.getQueueDirection(map.get("AR_TO_RIGHT").get(2));
        }
        if (map.get("AR_TO_LEFT").get(3) != null) {
            return StringUtils.getQueueDirection(map.get("AR_TO_LEFT").get(3)).getInv();
        }
        return null;
    }

    private CommandExecutionResult executePackageLink(Map<String, RegexPartialMatch> map) {
        LinkType linkType;
        String string;
        String string2 = map.get("G1").get(0);
        String string3 = map.get("G2").get(0);
        IEntityMutable iEntityMutable = ((ComponentDiagram)this.getSystem()).getGroup(string2);
        IEntityMutable iEntityMutable2 = ((ComponentDiagram)this.getSystem()).getGroup(string3);
        if (map.get("AR_TO_RIGHT").get(0) != null) {
            string = map.get("AR_TO_RIGHT").get(1) + map.get("AR_TO_RIGHT").get(3);
            linkType = this.getLinkTypeNormal(string, map.get("AR_TO_RIGHT").get(4));
        } else {
            string = map.get("AR_TO_LEFT").get(2) + map.get("AR_TO_LEFT").get(4);
            linkType = this.getLinkTypeNormal(string, map.get("AR_TO_LEFT").get(1)).getInversed();
        }
        Link link = new Link(iEntityMutable, iEntityMutable2, linkType, map.get("END").get(0), string.length());
        ((ComponentDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private LinkType getLinkTypeNormal(String string, String string2) {
        LinkType linkType = this.getLinkTypeFromKey(string2);
        if (string.startsWith(".")) {
            linkType = linkType.getDashed();
        }
        return linkType;
    }

    private LinkType getLinkTypeFromKey(String string) {
        if (string == null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (string.equals("<") || string.equals(">")) {
            return new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        }
        if (string.equals("<|") || string.equals("|>")) {
            return new LinkType(LinkDecor.EXTENDS, LinkDecor.NONE);
        }
        if (string.equals("^")) {
            return new LinkType(LinkDecor.EXTENDS, LinkDecor.NONE);
        }
        return null;
    }
}

