/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class City {
    private final Map<String, IEntity> entities = new LinkedHashMap<String, IEntity>();
    private HtmlColor backColor;
    private Group parent;

    public City(Group group) {
        this.parent = group;
    }

    public String toString() {
        return super.toString() + " " + this.entities;
    }

    public void addEntity(IEntity iEntity) {
        if (this.entities.containsValue(iEntity)) {
            throw new IllegalArgumentException();
        }
        if (this.entities.containsKey(iEntity.getCode())) {
            throw new IllegalArgumentException(iEntity.getCode());
        }
        this.entities.put(iEntity.getCode(), iEntity);
    }

    public boolean contains(IEntity iEntity) {
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
        return this.entities.containsValue(iEntity);
    }

    public Map<String, IEntity> entities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public final HtmlColor getBackColor() {
        return this.backColor;
    }

    public final void setBackColor(HtmlColor htmlColor) {
        this.backColor = htmlColor;
    }

    public final Group getParent() {
        return this.parent;
    }
}

