/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.CrossingType;
import net.sourceforge.plantuml.cucadiagram.EntityFactory;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityMutable;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupImpl;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMakerBeta;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMakerResult;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramPngMaker3;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower {
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private IEntityMutable currentGroup = null;
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private boolean visibilityModifierPresent;
    private final EntityFactory entityFactory = new EntityFactory();
    private String warningOrError;
    private final List<HideOrShow> hideOrShows = new ArrayList<HideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();

    private LinkedHashMap<String, IEntity> entities3() {
        return this.entityFactory.getEntities();
    }

    private List<Link> links3() {
        return this.entityFactory.getLinks();
    }

    private Map<String, IEntityMutable> groups3() {
        return this.entityFactory.getGroups();
    }

    public boolean hasUrl() {
        for (IEntity iEntity : this.entities3().values()) {
            if (iEntity.getUrls().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public IEntity getOrCreateEntity(String string, EntityType entityType) {
        IEntity iEntity = this.entities3().get(string);
        if (iEntity == null) {
            iEntity = this.createEntityInternal(string, string, entityType, this.getCurrentGroup());
        }
        return iEntity;
    }

    public IEntity createEntity(String string, String string2, EntityType entityType) {
        if (this.entities3().containsKey(string)) {
            throw new IllegalArgumentException("Already known: " + string);
        }
        return this.createEntityInternal(string, string2, entityType, this.getCurrentGroup());
    }

    protected final IEntity createEntityInternal(String string, String string2, EntityType entityType, IEntityMutable iEntityMutable) {
        if (string2 == null) {
            string2 = string;
        }
        IEntity iEntity = this.entityFactory.createEntity(string, string2, entityType, iEntityMutable, this.getHides());
        this.entities3().put(string, iEntity);
        return iEntity;
    }

    public boolean entityExist(String string) {
        return this.entities3().containsKey(string);
    }

    @Override
    public final Collection<? extends Group> getChildrenGroups(Group group) {
        ArrayList<IEntityMutable> arrayList = new ArrayList<IEntityMutable>();
        for (IEntityMutable iEntityMutable : this.groups3().values()) {
            if (!EntityUtils.equals(iEntityMutable.zgetParent(), group)) continue;
            arrayList.add(iEntityMutable);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public final IEntityMutable getOrCreateGroup(String string, String string2, String string3, GroupType groupType, IEntityMutable iEntityMutable) {
        IEntityMutable iEntityMutable2;
        this.currentGroup = iEntityMutable2 = this.getOrCreateGroupInternal(string, string2, string3, groupType, iEntityMutable);
        return iEntityMutable2;
    }

    protected final IEntityMutable getOrCreateGroupInternal(String string, String string2, String string3, GroupType groupType, IEntityMutable iEntityMutable) {
        return this.entityFactory.getOrCreateGroupInternal(string, string2, string3, groupType, iEntityMutable, this.getHides());
    }

    public final IEntityMutable getCurrentGroup() {
        return this.currentGroup;
    }

    public final IEntityMutable getGroup(String string) {
        IEntityMutable iEntityMutable = this.groups3().get(string);
        if (iEntityMutable == null) {
            return null;
        }
        return iEntityMutable;
    }

    public void endGroup() {
        if (this.currentGroup == null) {
            Log.error("No parent group");
            return;
        }
        this.currentGroup = (IEntityMutable)this.currentGroup.zgetParent();
    }

    public final boolean isGroup(String string) {
        return this.groups3().containsKey(string);
    }

    public final Collection<IEntityMutable> getGroups(boolean bl) {
        if (!bl) {
            return Collections.unmodifiableCollection(this.groups3().values());
        }
        ArrayList<IEntityMutable> arrayList = new ArrayList<IEntityMutable>();
        arrayList.add(this.getRootGroup());
        arrayList.addAll(this.groups3().values());
        return Collections.unmodifiableCollection(arrayList);
    }

    private IEntityMutable getRootGroup() {
        return new EntityMutable(new GroupImpl(null, null, null, GroupType.ROOT, null, this.entities3().values(), this.groups3().values()), this.entityFactory);
    }

    public final Map<String, IEntity> getEntities() {
        return Collections.unmodifiableMap(this.entities3());
    }

    public final void addLink(Link link) {
        this.links3().add(link);
    }

    protected final void removeLink(Link link) {
        boolean bl = this.links3().remove(link);
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links3());
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int n) {
        this.horizontalPages = n;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int n) {
        this.verticalPages = n;
    }

    public final List<File> createPng2(File file) throws IOException, InterruptedException {
        CucaDiagramPngMaker3 cucaDiagramPngMaker3 = new CucaDiagramPngMaker3(this);
        return cucaDiagramPngMaker3.createPng(file);
    }

    public final void createPng2(OutputStream outputStream) throws IOException {
        CucaDiagramPngMaker3 cucaDiagramPngMaker3 = new CucaDiagramPngMaker3(this);
        cucaDiagramPngMaker3.createPng(outputStream);
    }

    protected abstract List<String> getDotStrings();

    public final String[] getDotStringSkek() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getDotStrings()) {
            if (!string.startsWith("nodesep") && !string.startsWith("ranksep")) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void createFilesXmi(OutputStream outputStream, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker cucaDiagramXmiMaker = new CucaDiagramXmiMaker(this, fileFormat);
        cucaDiagramXmiMaker.createFiles(outputStream);
    }

    private List<File> createFilesHtml(File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        File file2 = new File(file.getParentFile(), string.substring(0, n));
        CucaDiagramHtmlMaker cucaDiagramHtmlMaker = new CucaDiagramHtmlMaker(this, file2);
        return cucaDiagramHtmlMaker.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> exportDiagrams(File file, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + file);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.HTML) {
            return this.createFilesHtml(file);
        }
        StringBuilder stringBuilder = new StringBuilder();
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.exportDiagram(outputStream, stringBuilder, 0, fileFormatOption);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        List<File> list = Arrays.asList(file);
        if (this.hasUrl() && stringBuilder.length() > 0) {
            this.exportCmap(file, stringBuilder);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            list = new PngSplitter(file, this.getHorizontalPages(), this.getVerticalPages(), this.getMetadata(), this.getDpi(fileFormatOption)).getFiles();
        }
        return list;
    }

    @Override
    protected final UmlDiagramInfo exportDiagramInternal(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption, List<BufferedImage> list) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(outputStream, n, fileFormat);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(new PrintStream(outputStream));
            }
            return new UmlDiagramInfo();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(outputStream, fileFormat);
            return new UmlDiagramInfo();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            CucaDiagramFileMakerBeta cucaDiagramFileMakerBeta = new CucaDiagramFileMakerBeta(this);
            try {
                cucaDiagramFileMakerBeta.createFile(outputStream, this.getDotStrings(), fileFormat);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.toString());
            }
            return new UmlDiagramInfo();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            CucaDiagramFileMakerBeta cucaDiagramFileMakerBeta = new CucaDiagramFileMakerBeta(this);
            try {
                cucaDiagramFileMakerBeta.createFile(outputStream, this.getDotStrings(), fileFormat);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new IOException(interruptedException.toString());
            }
            return new UmlDiagramInfo();
        }
        CucaDiagramFileMakerSvek cucaDiagramFileMakerSvek = new CucaDiagramFileMakerSvek(this, list);
        CucaDiagramFileMakerResult cucaDiagramFileMakerResult = cucaDiagramFileMakerSvek.createFile(outputStream, this.getDotStrings(), fileFormatOption);
        if (cucaDiagramFileMakerResult != null && stringBuilder != null && cucaDiagramFileMakerResult.getCmapResult() != null) {
            stringBuilder.append(cucaDiagramFileMakerResult.getCmapResult());
        }
        if (cucaDiagramFileMakerResult != null) {
            this.warningOrError = cucaDiagramFileMakerResult.getWarningOrError();
        }
        return cucaDiagramFileMakerResult == null ? new UmlDiagramInfo() : new UmlDiagramInfo(cucaDiagramFileMakerResult.getWidth());
    }

    @Override
    public String getWarningOrError() {
        String string = super.getWarningOrError();
        if (this.warningOrError == null) {
            return string;
        }
        if (string == null) {
            return this.warningOrError;
        }
        return string + "\n" + this.warningOrError;
    }

    private void createFilesTxt(OutputStream outputStream, int n, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker cucaDiagramTxtMaker = new CucaDiagramTxtMaker(this, fileFormat);
        cucaDiagramTxtMaker.createFiles(outputStream, n);
    }

    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    public boolean isAutarkic(Group group) {
        if (group.zgetGroupType() == GroupType.PACKAGE) {
            return false;
        }
        if (group.zgetGroupType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (group.zgetGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (group.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        if (this.getChildrenGroups(group).size() > 0) {
            return false;
        }
        for (Link link : this.links3()) {
            IEntityMutable iEntityMutable = (IEntityMutable)link.getEntity1();
            IEntityMutable iEntityMutable2 = (IEntityMutable)link.getEntity2();
            Group group2 = iEntityMutable.getContainer();
            Group group3 = iEntityMutable2.getContainer();
            if (!EntityUtils.equals(group2, group) && EntityUtils.equals(group3, group) && !iEntityMutable2.isGroup()) {
                return false;
            }
            if (EntityUtils.equals(group3, group) || !EntityUtils.equals(group2, group) || iEntityMutable.isGroup()) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(String string) {
        return string.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String string;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("labeldistance"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabeldistance"))) {
            return string;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String string;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("labelangle"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabelangle"))) {
            return string;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(Group group) {
        for (IEntityMutable iEntityMutable : this.groups3().values()) {
            if (EntityUtils.equals(iEntityMutable, group) || !EntityUtils.equals(iEntityMutable.zgetParent(), group)) continue;
            return false;
        }
        return group.zsize() == 0;
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean bl) {
        this.visibilityModifierPresent = bl;
    }

    private boolean isAutonom(IEntityMutable iEntityMutable) {
        for (Link link : this.links3()) {
            CrossingType crossingType = ((EntityMutable)iEntityMutable).getCrossingType(link);
            if (crossingType != CrossingType.CUT) continue;
            return false;
        }
        return true;
    }

    public final void computeAutonomyOfGroups() {
        for (IEntityMutable iEntityMutable : this.groups3().values()) {
            iEntityMutable.zsetAutonom(this.isAutonom(iEntityMutable));
        }
    }

    @Override
    public final boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
        boolean bl = true;
        for (HideOrShow hideOrShow : this.hideOrShows) {
            if (hideOrShow.portion != entityPortion || !hideOrShow.gender.contains(iEntity)) continue;
            bl = hideOrShow.show;
        }
        return bl;
    }

    public final void hideOrShow(EntityGender entityGender, Set<EntityPortion> set, boolean bl) {
        for (EntityPortion entityPortion : set) {
            this.hideOrShows.add(new HideOrShow(entityGender, entityPortion, bl));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> set, boolean bl) {
        if (bl) {
            this.hides.removeAll(set);
        } else {
            this.hides.addAll(set);
        }
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public ColorMapper getColorMapper() {
        return this.getSkinParam().getColorMapper();
    }

    public final boolean isStandalone(IEntity iEntity) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != iEntity && link.getEntity2() != iEntity) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        List<Link> list = this.getLinks();
        for (int i = list.size() - 1; i >= 0; --i) {
            Link link = list.get(i);
            if (link.getEntity1().getEntityType() == EntityType.NOTE || link.getEntity2().getEntityType() == EntityType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final IEntity getLastEntity() {
        Iterator<IEntity> iterator = this.entities3().values().iterator();
        while (iterator.hasNext()) {
            IEntity iEntity = iterator.next();
            if (iterator.hasNext()) continue;
            return iEntity;
        }
        return null;
    }

    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    static class HideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public HideOrShow(EntityGender entityGender, EntityPortion entityPortion, boolean bl) {
            this.gender = entityGender;
            this.portion = entityPortion;
            this.show = bl;
        }
    }
}

