/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.EntityImpl;
import net.sourceforge.plantuml.cucadiagram.EntityMutable;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupImpl;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityFactory {
    private final LinkedHashMap<String, IEntity> entities = new LinkedHashMap();
    private final List<Link> links = new ArrayList<Link>();
    private final Map<String, IEntityMutable> groups = new LinkedHashMap<String, IEntityMutable>();

    public IEntity createEntity(String string, String string2, EntityType entityType, IEntityMutable iEntityMutable, Set<VisibilityModifier> set) {
        return this.createEntity("cl", UniqueSequence.getValue(), string, string2, entityType, iEntityMutable, set);
    }

    public IEntity createEntity(String string, int n, String string2, String string3, EntityType entityType, IEntityMutable iEntityMutable, Set<VisibilityModifier> set) {
        return this.create(string, n, string2, StringUtils.getWithNewlines(string3), entityType, iEntityMutable, set);
    }

    public IEntity create(String string, int n, String string2, List<? extends CharSequence> list, EntityType entityType, IEntityMutable iEntityMutable, Set<VisibilityModifier> set) {
        Bodier bodier = new Bodier(entityType, set);
        return new EntityMutable(EntityImpl.createInternal(string, n, string2, list, entityType, iEntityMutable, bodier), this, bodier);
    }

    final LinkedHashMap<String, IEntity> getEntities() {
        return this.entities;
    }

    final List<Link> getLinks() {
        return this.links;
    }

    final Map<String, IEntityMutable> getGroups() {
        return this.groups;
    }

    public void overideImage42(EntityMutable entityMutable) {
        Object object;
        Iterator<Object> iterator = this.links.listIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Link link = ((Link)object).mute2(entityMutable);
            if (link != null) continue;
            iterator.remove();
        }
        this.groups.remove(entityMutable.zgetGroupCode());
        iterator = this.entities.values().iterator();
        while (iterator.hasNext()) {
            object = (IEntity)iterator.next();
            if (object == entityMutable || !EntityUtils.equals(EntityUtils.getContainerOrEquivalent((IEntity)object), entityMutable)) continue;
            iterator.remove();
        }
        this.entities.put(entityMutable.getCode(), entityMutable);
    }

    public final IEntityMutable getOrCreateGroupInternal(String string, String string2, String string3, GroupType groupType, IEntityMutable iEntityMutable, Set<VisibilityModifier> set) {
        EntityMutable entityMutable = (EntityMutable)this.getGroups().get(string);
        if (entityMutable == null) {
            entityMutable = this.createGroupSvek(string, string2, string3, groupType, iEntityMutable, set);
            this.getGroups().put(string, entityMutable);
        }
        return entityMutable;
    }

    private EntityMutable createGroupSvek(String string, String string2, String string3, GroupType groupType, IEntityMutable iEntityMutable, Set<VisibilityModifier> set) {
        GroupImpl groupImpl = new GroupImpl(string, string2, string3, groupType, iEntityMutable, this.getEntities().values(), this.getGroups().values());
        if (this.getEntities().containsKey(string)) {
            EntityMutable entityMutable = (EntityMutable)this.getEntities().get(string);
            entityMutable.muteToGroup99(groupImpl);
            this.entities.remove(string);
            entityMutable.setDisplay2(string2);
            entityMutable.invalidateNow();
            return entityMutable;
        }
        EntityMutable entityMutable = (EntityMutable)this.createEntity(string, string, null, iEntityMutable, set);
        entityMutable.muteToGroup99(groupImpl);
        return entityMutable;
    }
}

