/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BlockMember;
import net.sourceforge.plantuml.cucadiagram.BlockMemberImpl;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.graphic.TextBlockWidthVertical;
import net.sourceforge.plantuml.svek.IEntityImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImpl
implements IEntity {
    private final String code;
    private List<? extends CharSequence> display2;
    private final String uid;
    private EntityType type;
    private Stereotype stereotype;
    private String generic;
    private IEntityMutable container;
    private final List<Url> urls = new ArrayList<Url>();
    private final Bodier bodier;
    private boolean top;
    private HtmlColor specificBackcolor;
    private boolean nearDecoration = false;
    private int xposition;
    private IEntityImage svekImage;
    private final List<String> mouseOver = new ArrayList<String>();

    @Override
    public final boolean isTop() {
        return this.top;
    }

    @Override
    public final void setTop(boolean bl) {
        this.top = bl;
    }

    static EntityImpl createInternal(String string, int n, String string2, List<? extends CharSequence> list, EntityType entityType, IEntityMutable iEntityMutable, Bodier bodier) {
        return new EntityImpl(string, n, string2, list, entityType, iEntityMutable, bodier);
    }

    private EntityImpl(String string, int n, String string2, List<? extends CharSequence> list, EntityType entityType, IEntityMutable iEntityMutable, Bodier bodier) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.bodier = bodier;
        this.uid = StringUtils.getUid(string, n);
        this.type = entityType;
        this.code = string2;
        this.display2 = list;
        this.container = iEntityMutable;
    }

    @Override
    public void setContainer(IEntityMutable iEntityMutable) {
        if (iEntityMutable == null) {
            throw new IllegalArgumentException();
        }
        this.container = iEntityMutable;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    @Override
    public void muteToType(EntityType entityType) {
        if (this.type != EntityType.ABSTRACT_CLASS && this.type != EntityType.CLASS && this.type != EntityType.ENUM && this.type != EntityType.INTERFACE) {
            throw new IllegalArgumentException("type=" + (Object)((Object)this.type));
        }
        if (entityType != EntityType.ABSTRACT_CLASS && entityType != EntityType.CLASS && entityType != EntityType.ENUM && entityType != EntityType.INTERFACE) {
            throw new IllegalArgumentException("newtype=" + (Object)((Object)entityType));
        }
        this.type = entityType;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public List<? extends CharSequence> getDisplay2() {
        return this.display2;
    }

    @Override
    public void setDisplay2(String string) {
        this.display2 = StringUtils.getWithNewlines(string);
    }

    public void setDisplay2(List<? extends CharSequence> list) {
        this.display2 = list;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final Group getContainer() {
        return this.container;
    }

    public String toString() {
        return this.display2 + "(" + (Object)((Object)this.getEntityType()) + ") " + this.xposition + " " + this.getUid();
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    @Override
    public final List<Url> getUrls() {
        Url url;
        ArrayList<Url> arrayList = new ArrayList<Url>(this.urls);
        for (Member member : this.getFieldsToDisplay()) {
            url = member.getUrl();
            if (url == null) continue;
            arrayList.add(url);
        }
        for (Member member : this.getMethodsToDisplay()) {
            url = member.getUrl();
            if (url == null) continue;
            arrayList.add(url);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public final void addUrl(Url url) {
        if (url == null) {
            throw new UnsupportedOperationException();
        }
        this.urls.add(url);
    }

    @Override
    public final boolean hasNearDecoration() {
        return this.nearDecoration;
    }

    @Override
    public final void setNearDecoration(boolean bl) {
        this.nearDecoration = bl;
    }

    @Override
    public int getXposition() {
        return this.xposition;
    }

    @Override
    public void setXposition(int n) {
        this.xposition = n;
    }

    @Override
    public final IEntityImage getSvekImage() {
        return this.svekImage;
    }

    @Override
    public final void setSvekImage(IEntityImage iEntityImage) {
        this.svekImage = iEntityImage;
    }

    @Override
    public final void setGeneric(String string) {
        this.generic = string;
    }

    @Override
    public final String getGeneric() {
        return this.generic;
    }

    @Override
    public BlockMember getBody(final PortionShower portionShower) {
        if (this.getEntityType() == EntityType.CLASS && this.bodier.isBodyEnhanced()) {
            return this.bodier.getBodyEnhanced();
        }
        return new BlockMember(){

            public TextBlockWidth asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                if (EntityImpl.this.getEntityType() == EntityType.ABSTRACT_CLASS || EntityImpl.this.getEntityType() == EntityType.CLASS || EntityImpl.this.getEntityType() == EntityType.INTERFACE || EntityImpl.this.getEntityType() == EntityType.ENUM) {
                    boolean bl = portionShower.showPortion(EntityPortion.METHOD, EntityImpl.this);
                    boolean bl2 = portionShower.showPortion(EntityPortion.FIELD, EntityImpl.this);
                    if (bl2 && bl) {
                        return new TextBlockWidthVertical(new BlockMemberImpl(EntityImpl.this.getFieldsToDisplay()).asTextBlock(fontParam, iSkinParam), new BlockMemberImpl(EntityImpl.this.getMethodsToDisplay()).asTextBlock(fontParam, iSkinParam));
                    }
                    if (bl2) {
                        return new BlockMemberImpl(EntityImpl.this.getFieldsToDisplay()).asTextBlock(fontParam, iSkinParam);
                    }
                    if (bl) {
                        return new BlockMemberImpl(EntityImpl.this.getMethodsToDisplay()).asTextBlock(fontParam, iSkinParam);
                    }
                    return null;
                }
                if (EntityImpl.this.getEntityType() == EntityType.OBJECT) {
                    return new BlockMemberImpl(EntityImpl.this.getFieldsToDisplay()).asTextBlock(fontParam, iSkinParam);
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public BlockMember getMouseOver() {
        if (this.mouseOver.size() == 0) {
            return null;
        }
        return new BlockMember(){

            public TextBlockWidth asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                return new BodyEnhanced(EntityImpl.this.mouseOver, fontParam, iSkinParam);
            }
        };
    }

    @Override
    public void mouseOver(String string) {
        this.mouseOver.add(string);
    }

    @Override
    public List<Member> getFieldsToDisplay() {
        return this.bodier.getFieldsToDisplay();
    }

    @Override
    public List<Member> getMethodsToDisplay() {
        return this.bodier.getMethodsToDisplay();
    }

    @Override
    public void addFieldOrMethod(String string) {
        this.bodier.addFieldOrMethod(string);
    }
}

