/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.svek.PackageStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupImpl
implements Group {
    private final Collection<IEntity> allEntities;
    private final Collection<? extends Group> allGroups;
    private final String code;
    private final String display;
    private final String namespace;
    private HtmlColor backColor;
    private Group parent;
    private final GroupType type;
    private boolean autonom = true;
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private final int cpt = UniqueSequence.getValue();
    private Stereotype stereotype;

    public GroupImpl(String string, String string2, String string3, GroupType groupType, Group group, Collection<IEntity> collection, Collection<? extends Group> collection2) {
        if (groupType != GroupType.ROOT) {
            if (groupType == null) {
                throw new IllegalArgumentException();
            }
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
        }
        this.namespace = string3;
        this.type = groupType;
        this.parent = group;
        this.code = string;
        this.display = string2;
        this.allEntities = collection;
        this.allGroups = collection2;
    }

    public String toString() {
        return "G[code=" + this.code + "] autonom=" + this.zisAutonom();
    }

    @Override
    public boolean zcontains(IEntity iEntity) {
        GroupImpl groupImpl;
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
        GroupImpl groupImpl2 = groupImpl = this.type == GroupType.ROOT ? null : this;
        if (EntityUtils.equals(iEntity.getContainer(), groupImpl)) {
            return true;
        }
        for (Group group : this.zgetChildren()) {
            if (!group.zcontains(iEntity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IEntity> zentities() {
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        GroupImpl groupImpl = this.type == GroupType.ROOT ? null : this;
        for (IEntity iEntity : this.allEntities) {
            if (((IEntityMutable)iEntity).isGroup() || !EntityUtils.equals(iEntity.getContainer(), groupImpl)) continue;
            arrayList.add(iEntity);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public int zsize() {
        return this.zentities().size();
    }

    @Override
    public String zgetGroupCode() {
        return this.code;
    }

    @Override
    public String zgetUid() {
        return StringUtils.getUid(this.zgetUid1(), this.zgetUid2());
    }

    @Override
    public String zgetUid1() {
        return "cluster";
    }

    @Override
    public int zgetUid2() {
        return this.cpt;
    }

    @Override
    public final HtmlColor zgetBackColor() {
        return this.backColor;
    }

    @Override
    public final void zsetBackColor(HtmlColor htmlColor) {
        this.backColor = htmlColor;
    }

    @Override
    public final Group zgetParent() {
        return this.parent;
    }

    @Override
    public GroupType zgetGroupType() {
        return this.type;
    }

    @Override
    public String zgetDisplay() {
        return this.display;
    }

    @Override
    public void zmoveEntitiesTo(IEntityMutable iEntityMutable) {
        for (IEntity object : this.zentities()) {
            object.setContainer(iEntityMutable);
        }
        for (Group group : iEntityMutable.zgetChildren()) {
            ((GroupImpl)group).parent = (GroupImpl)((Object)iEntityMutable);
        }
    }

    @Override
    public String zgetNamespace() {
        return this.namespace;
    }

    public final Collection<Group> zgetChildren() {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (Group group : this.allGroups) {
            if (group.zgetUid2() == this.zgetUid2() || group.zgetParent() == null || group.zgetParent().zgetUid2() != this.zgetUid2()) continue;
            arrayList.add(group);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public final boolean zisAutonom() {
        return this.autonom;
    }

    @Override
    public final void zsetAutonom(boolean bl) {
        this.autonom = bl;
    }

    @Override
    public final Rankdir zgetRankdir() {
        return this.rankdir;
    }

    @Override
    public final void zsetRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    public final void zsetStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final Stereotype zgetStereotype() {
        return this.stereotype;
    }

    @Override
    public PackageStyle zgetPackageStyle() {
        if (this.stereotype == null) {
            return null;
        }
        return this.stereotype.getPackageStyle();
    }
}

