/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.EntityMutable;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link {
    private final IEntity cl1;
    private final IEntity cl2;
    private final LinkType type;
    private final String label;
    private int length;
    private final String qualifier1;
    private final String qualifier2;
    private final String uid = "LNK" + UniqueSequence.getValue();
    private List<? extends CharSequence> note;
    private Position notePosition;
    private HtmlColor noteColor;
    private boolean invis = false;
    private double weight = 1.0;
    private final String labeldistance;
    private final String labelangle;
    private HtmlColor specificColor;
    private boolean constraint = true;
    private boolean inverted = false;
    private LinkArrow linkArrow = LinkArrow.NONE;
    private boolean opale;
    private boolean horizontalSolitary;

    public final boolean isInverted() {
        return this.inverted;
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, String string, int n) {
        this(iEntity, iEntity2, linkType, string, n, null, null, null, null, null);
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, String string, int n, String string2, String string3, String string4, String string5) {
        this(iEntity, iEntity2, linkType, string, n, string2, string3, string4, string5, null);
    }

    public Link(IEntity iEntity, IEntity iEntity2, LinkType linkType, String string, int n, String string2, String string3, String string4, String string5, HtmlColor htmlColor) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (iEntity == null || iEntity2 == null) {
            throw new IllegalArgumentException();
        }
        if (iEntity.getEntityType() == EntityType.STATE_CONCURRENT) {
            throw new IllegalArgumentException();
        }
        if (iEntity2.getEntityType() == EntityType.STATE_CONCURRENT) {
            throw new IllegalArgumentException();
        }
        if (!(iEntity instanceof EntityMutable)) {
            throw new IllegalArgumentException();
        }
        if (!(iEntity2 instanceof EntityMutable)) {
            throw new IllegalArgumentException();
        }
        this.cl1 = iEntity;
        this.cl2 = iEntity2;
        this.type = linkType;
        this.label = string;
        this.length = n;
        this.qualifier1 = string2;
        this.qualifier2 = string3;
        this.labeldistance = string4;
        this.labelangle = string5;
        this.specificColor = htmlColor;
        if (string2 != null) {
            iEntity.setNearDecoration(true);
        }
        if (string3 != null) {
            iEntity2.setNearDecoration(true);
        }
    }

    public Link getInv() {
        Link link = new Link(this.cl2, this.cl1, this.getType().getInversed(), this.label, this.length, this.qualifier2, this.qualifier1, this.labeldistance, this.labelangle, this.specificColor);
        link.inverted = true;
        return link;
    }

    public Link getDashed() {
        return new Link(this.cl1, this.cl2, this.getType().getDashed(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public Link getDotted() {
        return new Link(this.cl1, this.cl2, this.getType().getDotted(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public Link getBold() {
        return new Link(this.cl1, this.cl2, this.getType().getBold(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle, this.specificColor);
    }

    public String getLabeldistance() {
        return this.labeldistance;
    }

    public String getLabelangle() {
        return this.labelangle;
    }

    public String getUid() {
        return this.uid;
    }

    public final boolean isInvis() {
        if (this.type.isInvisible()) {
            return true;
        }
        return this.invis;
    }

    public final void setInvis(boolean bl) {
        this.invis = bl;
    }

    public boolean insideGroup(Group group) {
        return EntityUtils.equals(this.cl1.getContainer(), group) && !((IEntityMutable)this.cl1).isGroup() && EntityUtils.equals(this.cl2.getContainer(), group) && !((IEntityMutable)this.cl2).isGroup();
    }

    private static IEntity muteProxy(IEntity iEntity, Group group, IEntity iEntity2) {
        if (((IEntityMutable)iEntity).isGroup() && EntityUtils.equals((Group)((Object)iEntity), group)) {
            return iEntity2;
        }
        return iEntity;
    }

    public Link mute(Group group, IEntity iEntity) {
        Group group2 = EntityUtils.getContainerOrEquivalent(this.cl1);
        Group group3 = EntityUtils.getContainerOrEquivalent(this.cl2);
        if (EntityUtils.equals(group2, group) && !((IEntityMutable)this.cl1).isGroup() && EntityUtils.equals(group, group3) && !((IEntityMutable)this.cl2).isGroup()) {
            return null;
        }
        IEntity iEntity2 = Link.muteProxy(this.cl1, group, iEntity);
        IEntity iEntity3 = Link.muteProxy(this.cl2, group, iEntity);
        if (this.cl1 == iEntity2 && this.cl2 == iEntity3) {
            return this;
        }
        return new Link(iEntity2, iEntity3, this.getType(), this.label, this.length, this.qualifier1, this.qualifier2, this.labeldistance, this.labelangle);
    }

    public Link mute2(Group group) {
        Group group2 = this.cl1.getContainer();
        Group group3 = this.cl2.getContainer();
        if (group2 == group && group3 == group) {
            return null;
        }
        return this;
    }

    public boolean isBetween(IEntity iEntity, IEntity iEntity2) {
        if (iEntity.equals(this.cl1) && iEntity2.equals(this.cl2)) {
            return true;
        }
        return iEntity.equals(this.cl2) && iEntity2.equals(this.cl1);
    }

    public String toString() {
        return super.toString() + " " + this.cl1 + "-->" + this.cl2;
    }

    public IEntity getEntity1() {
        return this.cl1;
    }

    public IEntity getEntity2() {
        return this.cl2;
    }

    public LinkType getType() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public String getQualifier1() {
        return this.qualifier1;
    }

    public String getQualifier2() {
        return this.qualifier2;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double d) {
        this.weight = d;
    }

    public final List<? extends CharSequence> getNote() {
        return this.note;
    }

    public final HtmlColor getNoteColor() {
        return this.noteColor;
    }

    public final Position getNotePosition() {
        return this.notePosition;
    }

    public final void addNote(List<? extends CharSequence> list, Position position, HtmlColor htmlColor) {
        this.note = list;
        this.notePosition = position;
        this.noteColor = htmlColor;
    }

    public final void addNote(String string, Position position, HtmlColor htmlColor) {
        this.note = StringUtils.getWithNewlines(string);
        this.notePosition = position;
        this.noteColor = htmlColor;
    }

    public boolean isAutolink(Group group) {
        if (!((IEntityMutable)this.getEntity1()).isGroup()) {
            return false;
        }
        if (!((IEntityMutable)this.getEntity2()).isGroup()) {
            return false;
        }
        return EntityUtils.equals(group, (Group)((Object)this.getEntity1())) && EntityUtils.equals(group, (Group)((Object)this.getEntity1()));
    }

    public boolean isAutoLinkOfAGroup() {
        if (!((IEntityMutable)this.getEntity1()).isGroup()) {
            return false;
        }
        if (!((IEntityMutable)this.getEntity2()).isGroup()) {
            return false;
        }
        return this.getEntity1() == this.getEntity2();
    }

    public boolean isToEdgeLink(Group group) {
        Group group2 = EntityUtils.getContainerOrEquivalent(this.getEntity1());
        Group group3 = EntityUtils.getContainerOrEquivalent(this.getEntity2());
        if (!EntityUtils.equals(group2, group) || !EntityUtils.equals(group3, group)) {
            return false;
        }
        assert (EntityUtils.equals(group2, group) && EntityUtils.equals(group3, group));
        if (this.isAutolink(group)) {
            return false;
        }
        if (((IEntityMutable)this.getEntity2()).isGroup()) {
            assert (!((EntityMutable)this.getEntity1()).isGroup());
            return true;
        }
        return false;
    }

    public boolean isFromEdgeLink(Group group) {
        Group group2 = EntityUtils.getContainerOrEquivalent(this.getEntity1());
        Group group3 = EntityUtils.getContainerOrEquivalent(this.getEntity2());
        if (!EntityUtils.equals(group2, group) || !EntityUtils.equals(group3, group)) {
            return false;
        }
        assert (EntityUtils.equals(group2, group) && EntityUtils.equals(group3, group));
        if (this.isAutolink(group)) {
            return false;
        }
        if (((EntityMutable)this.getEntity1()).isGroup()) {
            assert (!((EntityMutable)this.getEntity2()).isGroup());
            return true;
        }
        return false;
    }

    public boolean containsType(EntityType entityType) {
        return this.getEntity1().getEntityType() == entityType || this.getEntity2().getEntityType() == entityType;
    }

    public boolean contains(IEntity iEntity) {
        return this.getEntity1() == iEntity || this.getEntity2() == iEntity;
    }

    public IEntity getOther(IEntity iEntity) {
        if (this.getEntity1() == iEntity) {
            return this.getEntity2();
        }
        if (this.getEntity2() == iEntity) {
            return this.getEntity1();
        }
        throw new IllegalArgumentException();
    }

    public double getMarginDecors1(StringBounder stringBounder, UFont uFont, SpriteContainer spriteContainer) {
        double d = this.getQualifierMargin(stringBounder, uFont, this.qualifier1, spriteContainer);
        LinkDecor linkDecor = this.getType().getDecor1();
        return (double)linkDecor.getSize() + d;
    }

    public double getMarginDecors2(StringBounder stringBounder, UFont uFont, SpriteContainer spriteContainer) {
        double d = this.getQualifierMargin(stringBounder, uFont, this.qualifier2, spriteContainer);
        LinkDecor linkDecor = this.getType().getDecor2();
        return (double)linkDecor.getSize() + d;
    }

    private double getQualifierMargin(StringBounder stringBounder, UFont uFont, String string, SpriteContainer spriteContainer) {
        if (string != null) {
            TextBlock textBlock = TextBlockUtils.create(Arrays.asList(string), new FontConfiguration(uFont, HtmlColorUtils.BLACK), HorizontalAlignement.LEFT, spriteContainer);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            return Math.max(dimension2D.getWidth(), dimension2D.getHeight());
        }
        return 0.0;
    }

    public HtmlColor getSpecificColor() {
        return this.specificColor;
    }

    public void setSpecificColor(String string) {
        this.specificColor = HtmlColorUtils.getColorIfValid(string);
    }

    public final boolean isConstraint() {
        return this.constraint;
    }

    public final void setConstraint(boolean bl) {
        this.constraint = bl;
    }

    public void setOpale(boolean bl) {
        this.opale = bl;
    }

    public static boolean onlyOneLink(IEntity iEntity, Collection<Link> collection) {
        int n = 0;
        for (Link link : collection) {
            if (link.contains(iEntity)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return n == 1;
    }

    public final void setHorizontalSolitary(boolean bl) {
        this.horizontalSolitary = bl;
    }

    public final boolean isHorizontalSolitary() {
        return this.horizontalSolitary;
    }

    public final LinkArrow getLinkArrow() {
        if (this.inverted) {
            return this.linkArrow.reverse();
        }
        return this.linkArrow;
    }

    public final void setLinkArrow(LinkArrow linkArrow) {
        this.linkArrow = linkArrow;
    }
}

