/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class LinkType {
    private final LinkDecor decor1;
    private final LinkStyle style;
    private final LinkDecor decor2;

    public LinkType(LinkDecor linkDecor, LinkDecor linkDecor2) {
        this(linkDecor, LinkStyle.NORMAL, linkDecor2);
    }

    public boolean contains(LinkDecor linkDecor) {
        return this.decor1 == linkDecor || this.decor2 == linkDecor;
    }

    public String toString() {
        return (Object)((Object)this.decor1) + "-" + (Object)((Object)this.style) + "-" + (Object)((Object)this.decor2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        LinkType linkType = (LinkType)object;
        return this.decor1 == linkType.decor1 && this.decor2 == linkType.decor2 && this.style == linkType.style;
    }

    private LinkType(LinkDecor linkDecor, LinkStyle linkStyle, LinkDecor linkDecor2) {
        this.decor1 = linkDecor;
        this.style = linkStyle;
        this.decor2 = linkDecor2;
    }

    public boolean isDashed() {
        return this.style == LinkStyle.DASHED;
    }

    public boolean isDotted() {
        return this.style == LinkStyle.DOTTED;
    }

    public boolean isBold() {
        return this.style == LinkStyle.BOLD;
    }

    public boolean isInvisible() {
        return this.style == LinkStyle.INVISIBLE;
    }

    public LinkType getDashed() {
        return new LinkType(this.decor1, LinkStyle.DASHED, this.decor2);
    }

    public LinkType getDotted() {
        return new LinkType(this.decor1, LinkStyle.DOTTED, this.decor2);
    }

    public LinkType getBold() {
        return new LinkType(this.decor1, LinkStyle.BOLD, this.decor2);
    }

    public LinkType getInterfaceProvider() {
        return new LinkType(this.decor1, LinkStyle.__toremove_INTERFACE_PROVIDER, this.decor2);
    }

    public LinkType getInterfaceUser() {
        return new LinkType(this.decor1, LinkStyle.__toremove_INTERFACE_USER, this.decor2);
    }

    public LinkType getInversed() {
        return new LinkType(this.decor2, this.style, this.decor1);
    }

    public LinkType getInvisible() {
        return new LinkType(this.decor1, LinkStyle.INVISIBLE, this.decor2);
    }

    public String getSpecificDecoration() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.decor1 == LinkDecor.NONE && this.decor2 != LinkDecor.NONE) {
            stringBuilder.append("dir=back,");
        }
        if (this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE) {
            stringBuilder.append("dir=both,");
        }
        stringBuilder.append("arrowtail=");
        stringBuilder.append(this.decor2.getArrowDot());
        stringBuilder.append(",arrowhead=");
        stringBuilder.append(this.decor1.getArrowDot());
        if (this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS) {
            stringBuilder.append(",arrowsize=2");
        }
        if (this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS) {
            stringBuilder.append(",arrowsize=1.5");
        }
        if (this.style == LinkStyle.DASHED) {
            stringBuilder.append(",style=dashed");
        }
        if (this.style == LinkStyle.DOTTED) {
            stringBuilder.append(",style=dotted,");
        }
        if (this.style == LinkStyle.BOLD) {
            stringBuilder.append(",style=bold,");
        }
        return stringBuilder.toString();
    }

    public String getSpecificDecorationSvek() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.decor1 == LinkDecor.NONE && this.decor2 != LinkDecor.NONE) {
            stringBuilder.append("dir=back,");
        }
        if (this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE) {
            stringBuilder.append("dir=both,");
        }
        stringBuilder.append("arrowtail=");
        stringBuilder.append(this.decor2.getArrowDotSvek());
        stringBuilder.append(",arrowhead=");
        stringBuilder.append(this.decor1.getArrowDotSvek());
        if (this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS) {
            stringBuilder.append(",arrowsize=2");
        }
        if (this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS) {
            stringBuilder.append(",arrowsize=1.5");
        }
        if (this.decor1 == LinkDecor.COMPOSITION || this.decor2 == LinkDecor.COMPOSITION) {
            stringBuilder.append(",arrowsize=1.2");
        }
        if (this.decor1 == LinkDecor.AGREGATION || this.decor2 == LinkDecor.AGREGATION) {
            stringBuilder.append(",arrowsize=1.2");
        }
        return stringBuilder.toString();
    }

    public final LinkDecor getDecor1() {
        return this.decor1;
    }

    public final LinkStyle getStyle() {
        return this.style;
    }

    public final LinkDecor getDecor2() {
        return this.decor2;
    }

    public boolean isExtendsOrAgregationOrCompositionOrPlus() {
        return this.isExtends() || this.isAgregationOrComposition() || this.isPlus();
    }

    private boolean isExtends() {
        return this.decor1 == LinkDecor.EXTENDS || this.decor2 == LinkDecor.EXTENDS;
    }

    private boolean isPlus() {
        return this.decor1 == LinkDecor.PLUS || this.decor2 == LinkDecor.PLUS;
    }

    private boolean isAgregationOrComposition() {
        return this.decor1 == LinkDecor.AGREGATION || this.decor2 == LinkDecor.AGREGATION || this.decor1 == LinkDecor.COMPOSITION || this.decor2 == LinkDecor.COMPOSITION;
    }

    public LinkType getPart1() {
        return new LinkType(this.decor1, this.style, LinkDecor.NONE);
    }

    public LinkType getPart2() {
        return new LinkType(LinkDecor.NONE, this.style, this.decor2);
    }

    public UStroke getStroke() {
        if (this.style == LinkStyle.DASHED) {
            return new UStroke(7.0, 7.0, 1.0);
        }
        if (this.style == LinkStyle.DOTTED) {
            return new UStroke(1.0, 3.0, 1.0);
        }
        if (this.style == LinkStyle.BOLD) {
            return new UStroke(2.0);
        }
        return new UStroke();
    }
}

