/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.plantuml.Log;

public class ProcessRunner {
    private final String cmd;
    private String error;
    private String out;
    private static int cpt = 0;

    public ProcessRunner(String string) {
        this.cmd = string;
    }

    public void run(byte[] byArray, OutputStream outputStream) throws IOException, InterruptedException {
        this.run(byArray, outputStream, null);
    }

    public void run(byte[] byArray, OutputStream outputStream, File file) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(this.cmd, null, file);
        ThreadStream threadStream = new ThreadStream(process.getErrorStream(), null);
        ThreadStream threadStream2 = new ThreadStream(process.getInputStream(), outputStream);
        threadStream.start();
        threadStream2.start();
        if (byArray != null) {
            OutputStream outputStream2 = process.getOutputStream();
            outputStream2.write(byArray);
            outputStream2.close();
        }
        process.waitFor();
        threadStream.join(10000L);
        threadStream2.join(10000L);
        this.out = threadStream2.sb.toString();
        this.error = threadStream.sb.toString();
        Log.info("RUN nb = " + ++cpt);
    }

    public final String getError() {
        return this.error;
    }

    public final String getOut() {
        return this.out;
    }

    static class ThreadStream
    extends Thread {
        private final InputStream streamToRead;
        private final OutputStream redirection;
        private final StringBuilder sb = new StringBuilder();

        ThreadStream(InputStream inputStream, OutputStream outputStream) {
            this.streamToRead = inputStream;
            this.redirection = outputStream;
        }

        public void run() {
            Log.debug("STARTING " + this);
            int n = 0;
            try {
                while ((n = this.streamToRead.read()) != -1) {
                    if (this.redirection == null) {
                        this.sb.append((char)n);
                        continue;
                    }
                    this.redirection.write(n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.sb.append('\n');
                this.sb.append(iOException.toString());
            }
            Log.debug("FINISHING " + this);
        }
    }
}

