/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.EntityImageActivity;
import net.sourceforge.plantuml.graph.EntityImageActivityBar;
import net.sourceforge.plantuml.graph.EntityImageActivityBranch;
import net.sourceforge.plantuml.graph.EntityImageActivityCircle;
import net.sourceforge.plantuml.graph.EntityImageActor;
import net.sourceforge.plantuml.graph.EntityImageCircleInterface;
import net.sourceforge.plantuml.graph.EntityImageClass;
import net.sourceforge.plantuml.graph.EntityImageComponent;
import net.sourceforge.plantuml.graph.EntityImageDefault;
import net.sourceforge.plantuml.graph.EntityImageNote;
import net.sourceforge.plantuml.graph.EntityImageUsecase;

public class EntityImageFactory {
    public AbstractEntityImage createEntityImage(IEntity iEntity) {
        if (iEntity.getEntityType() == EntityType.CLASS || iEntity.getEntityType() == EntityType.ABSTRACT_CLASS || iEntity.getEntityType() == EntityType.INTERFACE || iEntity.getEntityType() == EntityType.ENUM) {
            return new EntityImageClass(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.ACTIVITY) {
            return new EntityImageActivity(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.NOTE) {
            return new EntityImageNote(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.POINT_FOR_ASSOCIATION) {
            return new EntityImageActivityCircle(iEntity, 4, 4);
        }
        if (iEntity.getEntityType() == EntityType.CIRCLE_START) {
            return new EntityImageActivityCircle(iEntity, 18, 18);
        }
        if (iEntity.getEntityType() == EntityType.CIRCLE_END) {
            return new EntityImageActivityCircle(iEntity, 18, 11);
        }
        if (iEntity.getEntityType() == EntityType.BRANCH) {
            return new EntityImageActivityBranch(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.SYNCHRO_BAR) {
            return new EntityImageActivityBar(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.USECASE) {
            return new EntityImageUsecase(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.ACTOR) {
            return new EntityImageActor(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.CIRCLE_INTERFACE) {
            return new EntityImageCircleInterface(iEntity);
        }
        if (iEntity.getEntityType() == EntityType.COMPONENT) {
            return new EntityImageComponent(iEntity);
        }
        return new EntityImageDefault(iEntity);
    }
}

