/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.AddStyle;
import net.sourceforge.plantuml.graphic.ColorAndSizeChange;
import net.sourceforge.plantuml.graphic.ColorChange;
import net.sourceforge.plantuml.graphic.FontFamilyChange;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.RemoveStyle;
import net.sourceforge.plantuml.graphic.ResetFont;
import net.sourceforge.plantuml.graphic.SizeChange;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.SpriteCommand;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextLink;

class HtmlCommandFactory {
    static final Pattern addStyle;
    static final Pattern removeStyle;
    private Pattern htmlTag = Pattern.compile(Splitter.htmlTag, 2);

    HtmlCommandFactory() {
    }

    HtmlCommand getHtmlCommand(String string) {
        if (!this.htmlTag.matcher(string).matches()) {
            return new Text(string);
        }
        if (string.matches("\\<img\\s+(src\\s*=\\s*['\"]?[^\\s\">]+['\"]?\\s*|vspace\\s*=\\s*['\"]?\\d+['\"]?\\s*|valign\\s*=\\s*['\"]?(top|middle|bottom)['\"]?\\s*)+\\>")) {
            return Img.getInstance(string);
        }
        if (string.matches("\\<img[\\s:]+([^>]+)/?\\>")) {
            return Img.getInstance2(string);
        }
        if (addStyle.matcher(string).matches()) {
            return new AddStyle(string);
        }
        if (removeStyle.matcher(string).matches()) {
            return new RemoveStyle(FontStyle.getStyle(string));
        }
        if (string.matches("\\<font(\\s+size\\s*=\\s*\"?\\d+\"?|\\s+color\\s*=\\s*\"?(#[0-9a-fA-F]{6}|\\w+)\"?)+\\s*\\>")) {
            return new ColorAndSizeChange(string);
        }
        if (string.matches("\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)\\s*\\>")) {
            return new ColorChange(string);
        }
        if (string.matches("\\<size[\\s:]+(\\d+)\\s*\\>")) {
            return new SizeChange(string);
        }
        if (string.matches("\\</font\\>|\\</color\\>|\\</size\\>")) {
            return new ResetFont();
        }
        if (string.matches("\\<font[\\s:]+([^>]+)/?\\>")) {
            return new FontFamilyChange(string);
        }
        if (string.matches("\\<\\$[\\p{L}0-9_]+\\>")) {
            return new SpriteCommand(string);
        }
        if (string.matches("\\[\\[([^\\[\\]]+)\\]\\]")) {
            Url url = StringUtils.extractUrl(string);
            url.setMember(true);
            return new TextLink(url);
        }
        return null;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (FontStyle fontStyle : EnumSet.allOf(FontStyle.class)) {
            if (fontStyle == FontStyle.PLAIN) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
                stringBuilder2.append('|');
            }
            stringBuilder.append(fontStyle.getActivationPattern());
            stringBuilder2.append(fontStyle.getDeactivationPattern());
        }
        addStyle = Pattern.compile(stringBuilder.toString(), 2);
        removeStyle = Pattern.compile(stringBuilder2.toString(), 2);
    }
}

