/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class TextBlockLineBefore
implements TextBlockWidth {
    private final TextBlockWidth textBlock;
    private final char separator;
    private final TextBlock title;

    public TextBlockLineBefore(TextBlockWidth textBlockWidth, char c, TextBlock textBlock) {
        this.textBlock = textBlockWidth;
        this.separator = c;
        this.title = textBlock;
    }

    public TextBlockLineBefore(TextBlockWidth textBlockWidth, char c) {
        this(textBlockWidth, c, null);
    }

    public TextBlockLineBefore(TextBlockWidth textBlockWidth) {
        this(textBlockWidth, '_');
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            Dimension2D dimension2D2 = this.title.calculateDimension(stringBounder);
            return Dimension2DDouble.atLeast(dimension2D, dimension2D2.getWidth() + 8.0, dimension2D2.getHeight());
        }
        return dimension2D;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, double d3) {
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        if (this.title == null) {
            this.drawLine(uGraphic, d, d2, d3);
        }
        this.textBlock.drawU(uGraphic, d, d2, d3);
        uGraphic.getParam().setColor(htmlColor);
        if (this.title != null) {
            Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
            double d4 = (d3 - dimension2D.getWidth()) / 2.0;
            this.drawLine(uGraphic, d, d2, d4 - 1.0);
            this.title.drawU(uGraphic, d + d4, d2 - dimension2D.getHeight() / 2.0 - 0.5);
            uGraphic.getParam().setColor(htmlColor);
            this.drawLine(uGraphic, d + d3 - d4 + 1.0, d2, d4 - 1.0);
        }
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, double d3) {
        d += 1.0;
        d3 -= 2.0;
        if (this.separator == '=') {
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
            uGraphic.draw(d, d2 + 2.0, new ULine(d3, 0.0));
        } else if (this.separator == '.') {
            uGraphic.getParam().setStroke(new UStroke(1.0, 2.0, 1.0));
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
            uGraphic.getParam().setStroke(new UStroke());
        } else if (this.separator == '-') {
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
        } else {
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
            uGraphic.getParam().setStroke(new UStroke());
        }
    }
}

