/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockWidthVertical
implements TextBlockWidth {
    private final List<TextBlockWidth> blocks = new ArrayList<TextBlockWidth>();

    public TextBlockWidthVertical(TextBlockWidth textBlockWidth, TextBlockWidth textBlockWidth2) {
        this.blocks.add(textBlockWidth);
        this.blocks.add(textBlockWidth2);
    }

    public TextBlockWidthVertical(List<TextBlockWidth> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(list);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dimension2D = Dimension2DDouble.mergeTB(dimension2D, this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2, double d3) {
        for (TextBlockWidth textBlockWidth : this.blocks) {
            textBlockWidth.drawU(uGraphic, d, d2, d3);
            Dimension2D dimension2D = textBlockWidth.calculateDimension(uGraphic.getStringBounder());
            d2 += dimension2D.getHeight();
        }
    }
}

