/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.html;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.html.LinkHtmlPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramHtmlMaker {
    private final CucaDiagram diagram;
    private final File dir;

    public CucaDiagramHtmlMaker(CucaDiagram cucaDiagram, File file) {
        this.diagram = cucaDiagram;
        this.dir = file;
    }

    public List<File> create() throws IOException {
        this.dir.mkdirs();
        if (!this.dir.exists()) {
            throw new IOException("Cannot create " + this.dir);
        }
        File file = new File(this.dir, "index.html");
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println("<html>");
        this.printAllType(printWriter, EntityType.ENUM);
        this.printAllType(printWriter, EntityType.INTERFACE);
        this.printAllType(printWriter, EntityType.ABSTRACT_CLASS);
        this.printAllType(printWriter, EntityType.CLASS);
        this.htmlClose(printWriter);
        return Arrays.asList(this.dir);
    }

    private void printAllType(PrintWriter printWriter, EntityType entityType) throws IOException {
        if (this.hasSome(entityType)) {
            printWriter.println("<h2>" + entityType.toHtml() + "</h2>");
            for (Map.Entry<String, IEntity> entry : new TreeMap<String, IEntity>(this.diagram.getEntities()).entrySet()) {
                if (entry.getValue().getEntityType() != entityType) continue;
                this.export(entry.getValue());
                printWriter.println("<li>");
                printWriter.println(LinkHtmlPrinter.htmlLink(entry.getValue()));
                printWriter.println("</li>");
            }
        }
    }

    private boolean hasSome(EntityType entityType) {
        for (IEntity iEntity : this.diagram.getEntities().values()) {
            if (iEntity.getEntityType() != entityType) continue;
            return true;
        }
        return false;
    }

    private void export(IEntity iEntity) throws IOException {
        File file = new File(this.dir, LinkHtmlPrinter.urlOf(iEntity));
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println("<html>");
        printWriter.println("<title>" + StringUtils.unicodeForHtml(iEntity.getCode()) + "</title>");
        printWriter.println("<h2>" + iEntity.getEntityType().toHtml() + "</h2>");
        for (CharSequence object32 : iEntity.getDisplay2()) {
            printWriter.println(StringUtils.unicodeForHtml(((Object)object32).toString()));
            printWriter.println("<br>");
        }
        Stereotype stereotype = iEntity.getStereotype();
        if (stereotype != null) {
            printWriter.println("<hr>");
            printWriter.println("<h3>Stereotype</h3>");
            for (String string : stereotype.getLabels()) {
                printWriter.println(string);
                printWriter.println("<br>");
            }
        }
        printWriter.println("<hr>");
        if (iEntity.getFieldsToDisplay().size() == 0) {
            printWriter.println("<h2>No fields</h2>");
        } else {
            printWriter.println("<h2>Fields:</h2>");
            printWriter.println("<ul>");
            for (Member member : iEntity.getFieldsToDisplay()) {
                printWriter.println("<li>");
                printWriter.println(StringUtils.unicodeForHtml(member.getDisplay(true)));
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        printWriter.println("<hr>");
        if (iEntity.getMethodsToDisplay().size() == 0) {
            printWriter.println("<h2>No methods</h2>");
        } else {
            printWriter.println("<h2>Methods:</h2>");
            printWriter.println("<ul>");
            for (Member member : iEntity.getMethodsToDisplay()) {
                printWriter.println("<li>");
                printWriter.println(StringUtils.unicodeForHtml(member.getDisplay(true)));
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        printWriter.println("<hr>");
        Collection<Link> collection = this.getLinksButNotes(iEntity);
        if (collection.size() == 0) {
            printWriter.println("<h2>No links</h2>");
        } else {
            printWriter.println("<h2>Links:</h2>");
            printWriter.println("<ul>");
            for (Object object : collection) {
                printWriter.println("<li>");
                new LinkHtmlPrinter((Link)object, iEntity).printLink(printWriter);
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        Collection<IEntity> collection2 = this.getNotes(iEntity);
        if (collection2.size() > 0) {
            printWriter.println("<hr>");
            printWriter.println("<h2>Notes:</h2>");
            printWriter.println("<ul>");
            for (IEntity iEntity2 : collection2) {
                printWriter.println("<li>");
                for (CharSequence charSequence : iEntity2.getDisplay2()) {
                    printWriter.println(StringUtils.unicodeForHtml(((Object)charSequence).toString()));
                    printWriter.println("<br>");
                }
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        this.htmlClose(printWriter);
    }

    private void htmlClose(PrintWriter printWriter) {
        printWriter.println("<hr>");
        printWriter.println("<a href=index.html>Back to index</a>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private Collection<IEntity> getNotes(IEntity iEntity) {
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(iEntity) || link.getEntity1().getEntityType() != EntityType.NOTE && link.getEntity2().getEntityType() != EntityType.NOTE) continue;
            arrayList.add(link.getOther(iEntity));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<Link> getLinksButNotes(IEntity iEntity) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(iEntity) || link.getEntity1().getEntityType() == EntityType.NOTE || link.getEntity2().getEntityType() == EntityType.NOTE) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

