/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdbc;

import java.sql.Blob;
import java.util.Arrays;
import net.sourceforge.plantuml.jdbc.PBlob;
import net.sourceforge.plantuml.jdbc.PData;
import net.sourceforge.plantuml.jdbc.PInteger;
import net.sourceforge.plantuml.jdbc.TraceObject;

public class PLine
extends TraceObject {
    private final PData[] data;

    public PLine(PData ... pDataArray) {
        this.data = pDataArray;
    }

    public int size() {
        return this.data.length;
    }

    public String toString() {
        return "PLine " + Arrays.asList(this.data);
    }

    public String getString(int n) {
        if (n < 0 || n - 1 >= this.data.length) {
            this.log(1, "data=" + Arrays.asList(this.data) + " columnIndex=" + n);
        }
        if (this.data[n - 1] == null) {
            return null;
        }
        return this.data[n - 1].toString();
    }

    public Object getObject(int n) {
        if (n < 0 || n - 1 >= this.data.length) {
            this.log(1, "data=" + Arrays.asList(this.data) + " columnIndex=" + n);
        }
        if (this.data[n - 1] == null) {
            return null;
        }
        return this.data[n - 1].getObject();
    }

    public Blob getBlob(int n) {
        if (n < 0 || n - 1 >= this.data.length) {
            this.log(1, "data=" + Arrays.asList(this.data) + " columnIndex=" + n);
        }
        if (this.data[n - 1] == null) {
            return null;
        }
        return ((PBlob)this.data[n - 1]).getBlob();
    }

    public int getInt(int n) {
        PData pData;
        if (n < 0 || n - 1 >= this.data.length) {
            this.log(1, "data=" + Arrays.asList(this.data) + " columnIndex=" + n);
        }
        if ((pData = this.data[n - 1]) instanceof PInteger) {
            return ((PInteger)pData).intValue();
        }
        this.log(1, "ERROR " + pData.getObject());
        return 0;
    }
}

