/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagram;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateEntityObjectMultilines
extends CommandMultilines<ObjectDiagram> {
    public CommandCreateEntityObjectMultilines(ObjectDiagram objectDiagram) {
        super(objectDiagram, "(?i)^(object)\\s+(?:\"([^\"]+)\"\\s+as\\s+)?([\\p{L}0-9_.]+)(?:\\s*([\\<\\[]{2}.*[\\>\\]]{2}))?\\s*\\{\\s*$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^\\s*\\}\\s*$";
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        StringUtils.trim(list, true);
        List<String> list2 = StringUtils.getSplit(this.getStartingPattern(), list.get(0).trim());
        IEntity iEntity = this.executeArg0(list2);
        if (iEntity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        for (String string : list.subList(1, list.size() - 1)) {
            assert (string.length() > 0);
            if (VisibilityModifier.isVisibilityCharacter(string.charAt(0))) {
                ((ObjectDiagram)this.getSystem()).setVisibilityModifierPresent(true);
            }
            iEntity.addFieldOrMethod(string);
        }
        return CommandExecutionResult.ok();
    }

    private IEntity executeArg0(List<String> list) {
        String string = list.get(2);
        String string2 = list.get(1);
        String string3 = list.get(3);
        if (((ObjectDiagram)this.getSystem()).entityExist(string)) {
            return ((ObjectDiagram)this.getSystem()).getOrCreateClass(string);
        }
        IEntity iEntity = ((ObjectDiagram)this.getSystem()).createEntity(string, string2, EntityType.OBJECT);
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3, ((ObjectDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ObjectDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        return iEntity;
    }
}

