/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.posimo.Positionable;

public class BezierUtils {
    static double getEndingAngle(CubicCurve2D.Double double_) {
        if (double_.getCtrlP2().equals(double_.getP2())) {
            return BezierUtils.getAngle(double_.getP1(), double_.getP2());
        }
        return BezierUtils.getAngle(double_.getCtrlP2(), double_.getP2());
    }

    static double getStartingAngle(CubicCurve2D.Double double_) {
        if (double_.getP1().equals(double_.getCtrlP1())) {
            return BezierUtils.getAngle(double_.getP1(), double_.getP2());
        }
        return BezierUtils.getAngle(double_.getP1(), double_.getCtrlP1());
    }

    static double getAngle(Point2D point2D, Point2D point2D2) {
        if (point2D.equals(point2D2)) {
            throw new IllegalArgumentException();
        }
        double d = -Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX());
        d = d * 180.0 / Math.PI;
        if ((d -= 90.0) >= 360.0) {
            d -= 360.0;
        }
        if (d < 0.0) {
            d += 360.0;
        }
        return d;
    }

    static boolean isCutting(CubicCurve2D.Double double_, Shape shape) {
        boolean bl = shape.contains(double_.x1, double_.y1);
        boolean bl2 = shape.contains(double_.x2, double_.y2);
        return bl ^ bl2;
    }

    static void shorten(CubicCurve2D.Double double_, Shape shape) {
        boolean bl;
        boolean bl2 = shape.contains(double_.x1, double_.y1);
        if (bl2 ^ !(bl = shape.contains(double_.x2, double_.y2))) {
            throw new IllegalArgumentException();
        }
        if (!bl2) {
            double_.setCurve(double_.x2, double_.y2, double_.ctrlx2, double_.ctrly2, double_.ctrlx1, double_.ctrly1, double_.x1, double_.y1);
        }
        assert (shape.contains(double_.x1, double_.y1) && !shape.contains(double_.x2, double_.y2));
        CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
        CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
        BezierUtils.subdivide(double_, double_2, double_3, 0.5);
        if (BezierUtils.isCutting(double_2, shape) ^ !BezierUtils.isCutting(double_3, shape)) {
            throw new IllegalArgumentException();
        }
        if (BezierUtils.isCutting(double_2, shape)) {
            double_.setCurve(double_2);
        } else {
            double_.setCurve(double_3);
        }
    }

    public static void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2, CubicCurve2D cubicCurve2D3, double d) {
        double d2 = d;
        double d3 = 1.0 - d;
        double d4 = cubicCurve2D.getCtrlX1() * d2 + cubicCurve2D.getCtrlX2() * d3;
        double d5 = cubicCurve2D.getCtrlY1() * d2 + cubicCurve2D.getCtrlY2() * d3;
        double d6 = cubicCurve2D.getX1() * d2 + cubicCurve2D.getCtrlX1() * d2;
        double d7 = cubicCurve2D.getY1() * d2 + cubicCurve2D.getCtrlY1() * d2;
        double d8 = cubicCurve2D.getX2() * d2 + cubicCurve2D.getCtrlX2() * d2;
        double d9 = cubicCurve2D.getY2() * d2 + cubicCurve2D.getCtrlY2() * d2;
        double d10 = d6 * d2 + d4 * d2;
        double d11 = d7 * d2 + d5 * d2;
        double d12 = d8 * d2 + d4 * d2;
        double d13 = d9 * d2 + d5 * d2;
        double d14 = d10 * d2 + d12 * d2;
        double d15 = d11 * d2 + d13 * d2;
        cubicCurve2D2.setCurve(cubicCurve2D.getX1(), cubicCurve2D.getY1(), d6, d7, d10, d11, d14, d15);
        cubicCurve2D3.setCurve(d14, d15, d12, d13, d8, d9, cubicCurve2D.getX2(), cubicCurve2D.getY2());
    }

    static double dist(CubicCurve2D.Double double_) {
        return Point2D.distance(double_.x1, double_.y1, double_.x2, double_.y2);
    }

    static double dist(Line2D.Double double_) {
        return Point2D.distance(double_.x1, double_.y1, double_.x2, double_.y2);
    }

    public static Point2D middle(Line2D.Double double_) {
        return new Point2D.Double((double_.x1 + double_.x2) / 2.0, (double_.y1 + double_.y2) / 2.0);
    }

    public static Point2D middle(Point2D point2D, Point2D point2D2) {
        return new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
    }

    public static Point2D intersect(Line2D.Double double_, Shape shape) {
        boolean bl;
        Line2D.Double double_2 = new Line2D.Double(double_.x1, double_.y1, double_.x2, double_.y2);
        boolean bl2 = shape.contains(double_2.x1, double_2.y1);
        if (bl2 ^ !(bl = shape.contains(double_2.x2, double_2.y2))) {
            throw new IllegalArgumentException();
        }
        do {
            double d;
            double d2;
            boolean bl3;
            if (bl2 == (bl3 = shape.contains(d2 = (double_2.x1 + double_2.x2) / 2.0, d = (double_2.y1 + double_2.y2) / 2.0))) {
                double_2.x1 = d2;
                double_2.y1 = d;
                continue;
            }
            double_2.x2 = d2;
            double_2.y2 = d;
        } while (!(BezierUtils.dist(double_2) < 0.1));
        if (bl2) {
            return new Point2D.Double(double_2.x2, double_2.y2);
        }
        if (bl) {
            return new Point2D.Double(double_2.x1, double_2.y1);
        }
        throw new IllegalStateException();
    }

    public static Rectangle2D toRectangle(Positionable positionable) {
        Point2D point2D = positionable.getPosition();
        Dimension2D dimension2D = positionable.getSize();
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public static boolean intersect(Positionable positionable, Positionable positionable2) {
        return BezierUtils.toRectangle(positionable).intersects(BezierUtils.toRectangle(positionable2));
    }

    public static Point2D.Double getCenter(Positionable positionable) {
        return new Point2D.Double(BezierUtils.toRectangle(positionable).getCenterX(), BezierUtils.toRectangle(positionable).getCenterY());
    }
}

