/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class GraphicalDelayText
extends GraphicalElement {
    private final Component compText;
    private final ParticipantBox p1;
    private final ParticipantBox p2;

    public GraphicalDelayText(double d, Component component, ParticipantBox participantBox, ParticipantBox participantBox2) {
        super(d);
        this.compText = component;
        this.p1 = participantBox;
        this.p2 = participantBox2;
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d2 = this.p1.getCenterX(stringBounder);
        double d3 = this.p2.getCenterX(stringBounder);
        double d4 = (d2 + d3) / 2.0;
        double d5 = this.compText.getPreferredWidth(stringBounder);
        uGraphic.translate(d4 - d5 / 2.0, this.getStartingY());
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d5, this.compText.getPreferredHeight(stringBounder));
        this.compText.drawU(uGraphic, new Area(dimension2DDouble), context2D);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.compText.getPreferredHeight(stringBounder);
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.compText.getPreferredWidth(stringBounder);
    }

    public double getStartingX(StringBounder stringBounder) {
        return 0.0;
    }

    public double getEndingY(StringBounder stringBounder) {
        return this.getStartingY() + this.compText.getPreferredHeight(stringBounder);
    }
}

